/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.dmr.ModelNode;

public class ServerRestartHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "restart";
    private final ServerInventory serverInventory;

    public ServerRestartHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(new ModelNode(HostControllerMessages.MESSAGES.cannotStartServersInvalidMode(context.getRunningMode())));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final ModelNode model = Resource.Tools.readModel((Resource)context.getRootResource());
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerStatus origStatus = ServerRestartHandler.this.serverInventory.determineServerStatus(serverName);
                if (origStatus != ServerStatus.STARTED) {
                    throw new OperationFailedException(new ModelNode(HostControllerMessages.MESSAGES.cannotRestartServer(serverName, origStatus)));
                }
                ServerStatus status = ServerRestartHandler.this.serverInventory.restartServer(serverName, -1, model);
                context.getResult().set(status.toString());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getRestartServerOperation(locale);
    }
}

