/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.PropertyValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JvmAttributes {
    public static final String JVM_AGENT_LIB = "agent-lib";
    public static final String JVM_AGENT_PATH = "agent-path";
    public static final String JVM_DEBUG_ENABLED = "debug-enabled";
    public static final String JVM_DEBUG_OPTIONS = "debug-options";
    public static final String JVM_ENV_CLASSPATH_IGNORED = "env-classpath-ignored";
    public static final String JVM_ENV_VARIABLES = "environment-variables";
    public static final String JVM_HEAP = "heap-size";
    public static final String JVM_MAX_HEAP = "max-heap-size";
    public static final String JVM_JAVA_AGENT = "java-agent";
    public static final String JVM_JAVA_HOME = "java-home";
    public static final String JVM_OPTIONS = "jvm-options";
    public static final String JVM_OPTION = "jvm-option";
    public static final String JVM_PERMGEN = "permgen-size";
    public static final String JVM_MAX_PERMGEN = "max-permgen-size";
    public static final String JVM_STACK = "stack-size";
    public static final String JVM_TYPE = "type";
    public static final String SIZE = "size";
    public static final String VALUE = "value";
    public static final String MAX_SIZE = "max-size";
    public static final SimpleAttributeDefinition AGENT_LIB = SimpleAttributeDefinitionBuilder.create((String)"agent-lib", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("value").build();
    public static final SimpleAttributeDefinition AGENT_PATH = SimpleAttributeDefinitionBuilder.create((String)"agent-path", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("value").build();
    public static final SimpleAttributeDefinition ENV_CLASSPATH_IGNORED = SimpleAttributeDefinitionBuilder.create((String)"env-classpath-ignored", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false).build();
    public static final AttributeDefinition ENVIRONMENT_VARIABLES = new EnvironmentVariableAttributeDefinition("environment-variables", Element.VARIABLE.getLocalName());
    public static final SimpleAttributeDefinition JAVA_AGENT = SimpleAttributeDefinitionBuilder.create((String)"java-agent", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("value").build();
    public static final SimpleAttributeDefinition JAVA_HOME = SimpleAttributeDefinitionBuilder.create((String)"java-home", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).build();
    public static final AttributeDefinition OPTIONS = new JVMOptionsAttributeDefiniton("jvm-options", Element.OPTION.getLocalName());
    public static final SimpleAttributeDefinition STACK_SIZE = SimpleAttributeDefinitionBuilder.create((String)"stack-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("size").build();
    public static final SimpleAttributeDefinition TYPE = SimpleAttributeDefinitionBuilder.create((String)"type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setValidator((ParameterValidator)new EnumValidator(JvmType.class, true, true)).build();
    public static final SimpleAttributeDefinition HEAP_SIZE = SimpleAttributeDefinitionBuilder.create((String)"heap-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("size").build();
    public static final SimpleAttributeDefinition MAX_HEAP_SIZE = SimpleAttributeDefinitionBuilder.create((String)"max-heap-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("max-size").build();
    public static final SimpleAttributeDefinition PERMGEN_SIZE = SimpleAttributeDefinitionBuilder.create((String)"permgen-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("size").build();
    public static final SimpleAttributeDefinition MAX_PERMGEN_SIZE = SimpleAttributeDefinitionBuilder.create((String)"max-permgen-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setXmlName("max-size").build();
    public static final SimpleAttributeDefinition DEBUG_ENABLED = SimpleAttributeDefinitionBuilder.create((String)"debug-enabled", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false).build();
    public static final SimpleAttributeDefinition DEBUG_OPTIONS = SimpleAttributeDefinitionBuilder.create((String)"debug-options", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).build();
    private static final AttributeDefinition[] GLOBAL_ATTRIBUTES = new AttributeDefinition[]{AGENT_LIB, AGENT_PATH, ENV_CLASSPATH_IGNORED, ENVIRONMENT_VARIABLES, JAVA_AGENT, JAVA_HOME, OPTIONS, STACK_SIZE, TYPE, HEAP_SIZE, MAX_HEAP_SIZE, PERMGEN_SIZE, MAX_PERMGEN_SIZE};
    private static final AttributeDefinition[] SERVER_ATTRIBUTES = new AttributeDefinition[]{AGENT_LIB, AGENT_PATH, ENV_CLASSPATH_IGNORED, ENVIRONMENT_VARIABLES, JAVA_AGENT, JAVA_HOME, OPTIONS, STACK_SIZE, TYPE, HEAP_SIZE, MAX_HEAP_SIZE, PERMGEN_SIZE, MAX_PERMGEN_SIZE, DEBUG_ENABLED, DEBUG_OPTIONS};

    static AttributeDefinition[] getAttributes(boolean server) {
        return server ? SERVER_ATTRIBUTES : GLOBAL_ATTRIBUTES;
    }

    static class JVMOptionsAttributeDefiniton
    extends AbstractJvmListAttributeDefinition {
        JVMOptionsAttributeDefiniton(String name, String elementName) {
            super(name, elementName, (ParameterValidator)new StringLengthValidator(1, false));
        }

        @Override
        void setValueType(ModelNode node) {
            node.get("value-type").set(ModelType.STRING);
        }

        @Override
        void writeList(List<ModelNode> list, XMLStreamWriter writer) throws XMLStreamException {
            for (ModelNode child : list) {
                writer.writeEmptyElement(this.elementName);
                writer.writeAttribute(JvmAttributes.VALUE, child.asString());
            }
        }
    }

    static class EnvironmentVariableAttributeDefinition
    extends AbstractJvmListAttributeDefinition {
        EnvironmentVariableAttributeDefinition(String name, String elementName) {
            super(name, elementName, (ParameterValidator)new PropertyValidator(false, (ParameterValidator)new StringLengthValidator(1)));
        }

        @Override
        void setValueType(ModelNode node) {
            node.get("value-type").set(ModelType.PROPERTY);
        }

        @Override
        void writeList(List<ModelNode> list, XMLStreamWriter writer) throws XMLStreamException {
            for (ModelNode child : list) {
                writer.writeEmptyElement(this.elementName);
                writer.writeAttribute("name", child.asProperty().getName());
                writer.writeAttribute(JvmAttributes.VALUE, child.asProperty().getValue().asString());
            }
        }
    }

    static abstract class AbstractJvmListAttributeDefinition
    extends ListAttributeDefinition {
        protected final String elementName;

        AbstractJvmListAttributeDefinition(String name, String elementName, ParameterValidator elementValidator) {
            super(name, true, elementValidator);
            this.elementName = elementName;
        }

        public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(this.getName()) && (list = resourceModel.get(this.getName()).asList()).size() > 0) {
                writer.writeStartElement(this.getName());
                this.writeList(list, writer);
                writer.writeEndElement();
            }
        }

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            this.setValueType(node);
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            this.setValueType(node);
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            this.setValueType(node);
        }

        abstract void setValueType(ModelNode var1);

        abstract void writeList(List<ModelNode> var1, XMLStreamWriter var2) throws XMLStreamException;
    }
}

