/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;

public class HostModelRegistrationHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "register-host-model";
    private final HostControllerEnvironment hostControllerEnvironment;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final HostModelUtil.HostModelRegistrar hostModelRegistrar;

    public HostModelRegistrationHandler(HostControllerEnvironment hostControllerEnvironment, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostModelUtil.HostModelRegistrar hostModelRegistrar) {
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.hostModelRegistrar = hostModelRegistrar;
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    public void execute(OperationContext context, ModelNode operation) {
        if (!context.isBooting()) {
            throw HostControllerMessages.MESSAGES.invocationNotAllowedAfterBoot(OPERATION_NAME);
        }
        String hostName = operation.require("name").asString();
        ManagementResourceRegistration rootRegistration = context.getResourceRegistrationForUpdate();
        this.hostModelRegistrar.registerHostModel(hostName, rootRegistration);
        PathAddress hostAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)hostName)});
        Resource rootResource = context.createResource(hostAddress);
        ModelNode model = rootResource.getModel();
        HostModelRegistrationHandler.initCoreModel(model, this.hostControllerEnvironment);
        context.createResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
        context.createResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"host-environment")}));
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
        Resource.ResourceEntry ignoredRoot = this.ignoredDomainResourceRegistry.getRootResource();
        rootResource.registerChild(ignoredRoot.getPathElement(), (Resource)ignoredRoot);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private static void initCoreModel(ModelNode root, HostControllerEnvironment environment) {
        root.get("release-version").set(Version.AS_VERSION);
        root.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        root.get("management-major-version").set(1);
        root.get("management-minor-version").set(3);
        root.get("management-micro-version").set(0);
        ModelNode nameNode = root.get("product-name");
        ModelNode versionNode = root.get("product-version");
        if (environment != null) {
            String productName = environment.getProductConfig().getProductName();
            String productVersion = environment.getProductConfig().getProductVersion();
            if (productName != null) {
                nameNode.set(productName);
            }
            if (productVersion != null) {
                versionNode.set(productVersion);
            }
        }
        root.get("name");
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("extension");
        root.get("system-property");
        root.get("path");
        root.get("core-service");
        root.get("server-config");
        root.get("domain-controller");
        root.get("interface");
        root.get("jvm");
        root.get("server");
    }
}

