/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.ConfigurationPersisterFactory;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;

public class HostControllerConfigurationPersister
implements ExtensibleConfigurationPersister {
    private final HostControllerEnvironment environment;
    private ExtensibleConfigurationPersister domainPersister;
    private final ExtensibleConfigurationPersister hostPersister;
    private final LocalHostControllerInfo hostControllerInfo;
    private final ExecutorService executorService;
    private final ExtensionRegistry extensionRegistry;
    private Boolean slave;

    public HostControllerConfigurationPersister(HostControllerEnvironment environment, LocalHostControllerInfo localHostControllerInfo, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        this.environment = environment;
        this.hostControllerInfo = localHostControllerInfo;
        this.executorService = executorService;
        this.extensionRegistry = extensionRegistry;
        ConfigurationFile configurationFile = environment.getHostConfigurationFile();
        if (environment.getRunningModeControl().isReloaded()) {
            configurationFile.resetBootFile(environment.getRunningModeControl().isUseCurrentConfig());
        }
        this.hostPersister = ConfigurationPersisterFactory.createHostXmlConfigurationPersister(configurationFile, environment.getHostControllerName());
    }

    public void initializeDomainConfigurationPersister(boolean slave) {
        if (this.domainPersister != null) {
            throw HostControllerMessages.MESSAGES.configurationPersisterAlreadyInitialized();
        }
        File configDir = this.environment.getDomainConfigurationDir();
        if (slave) {
            this.domainPersister = this.environment.isBackupDomainFiles() ? ConfigurationPersisterFactory.createRemoteBackupDomainXmlConfigurationPersister(configDir, this.executorService, this.extensionRegistry) : (this.environment.isUseCachedDc() ? ConfigurationPersisterFactory.createCachedRemoteDomainXmlConfigurationPersister(configDir, this.executorService, this.extensionRegistry) : ConfigurationPersisterFactory.createTransientDomainXmlConfigurationPersister(this.executorService, this.extensionRegistry));
        } else {
            ConfigurationFile configurationFile = this.environment.getDomainConfigurationFile();
            if (this.environment.getRunningModeControl().isReloaded()) {
                configurationFile.resetBootFile(this.environment.getRunningModeControl().isUseCurrentDomainConfig());
            }
            this.domainPersister = ConfigurationPersisterFactory.createDomainXmlConfigurationPersister(configurationFile, this.executorService, this.extensionRegistry);
        }
        this.slave = slave;
    }

    public boolean isSlave() {
        if (this.slave == null) {
            throw HostControllerMessages.MESSAGES.mustInvokeBeforeCheckingSlaveStatus("initializeDomainConfigurationPersister");
        }
        return this.slave;
    }

    public ExtensibleConfigurationPersister getDomainPersister() {
        if (this.domainPersister == null) {
            throw HostControllerMessages.MESSAGES.mustInvokeBeforePersisting("initializeDomainConfigurationPersister");
        }
        return this.domainPersister;
    }

    public ExtensibleConfigurationPersister getHostPersister() {
        return this.hostPersister;
    }

    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        final ConfigurationPersister.PersistenceResource[] delegates = new ConfigurationPersister.PersistenceResource[2];
        for (PathAddress addr : affectedAddresses) {
            if (delegates[0] == null && addr.size() > 0 && "host".equals(addr.getElement(0).getKey()) && addr.getElement(0).getValue().equals(this.hostControllerInfo.getLocalHostName())) {
                ModelNode hostModel = new ModelNode();
                hostModel.set(model.get(new String[]{"host", this.hostControllerInfo.getLocalHostName()}));
                delegates[0] = this.hostPersister.store(hostModel, affectedAddresses);
            } else if (!(delegates[1] != null || addr.size() != 0 && "host".equals(addr.getElement(0).getKey()))) {
                delegates[1] = this.getDomainPersister().store(model, affectedAddresses);
            }
            if (delegates[0] == null || delegates[1] == null) continue;
            break;
        }
        return new ConfigurationPersister.PersistenceResource(){

            public void commit() {
                if (delegates[0] != null) {
                    delegates[0].commit();
                }
                if (delegates[1] != null) {
                    delegates[1].commit();
                }
            }

            public void rollback() {
                if (delegates[0] != null) {
                    delegates[0].rollback();
                }
                if (delegates[1] != null) {
                    delegates[1].rollback();
                }
            }
        };
    }

    public void marshallAsXml(ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
        throw new UnsupportedOperationException();
    }

    public List<ModelNode> load() throws ConfigurationPersistenceException {
        return this.hostPersister.load();
    }

    public void successfulBoot() throws ConfigurationPersistenceException {
        this.hostPersister.successfulBoot();
        if (this.domainPersister != null) {
            this.domainPersister.successfulBoot();
        }
    }

    public String snapshot() throws ConfigurationPersistenceException {
        throw new UnsupportedOperationException();
    }

    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        throw new UnsupportedOperationException();
    }

    public void deleteSnapshot(String name) {
        throw new UnsupportedOperationException();
    }

    public void registerSubsystemWriter(String name, XMLElementWriter<SubsystemMarshallingContext> writer) {
        this.domainPersister.registerSubsystemWriter(name, writer);
    }

    public void unregisterSubsystemWriter(String name) {
        this.domainPersister.unregisterSubsystemWriter(name);
    }

    @Deprecated
    public void registerSubsystemDeploymentWriter(String name, XMLElementWriter<SubsystemMarshallingContext> writer) {
        this.domainPersister.registerSubsystemDeploymentWriter(name, writer);
    }

    @Deprecated
    public void unregisterSubsystemDeploymentWriter(String name) {
        this.domainPersister.unregisterSubsystemDeploymentWriter(name);
    }
}

