/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.util.Arrays;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.jaxrs.JaxrsLogger;
import org.jboss.as.jaxrs.JaxrsMessages;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.resteasy.util.GetRestful;

public class JaxrsComponentDeployer
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        if (!resteasy.isScanResources()) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ModuleClassLoader loader = module.getClassLoader();
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            Class<?> componentClass = null;
            try {
                componentClass = loader.loadClass(component.getComponentClassName());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!GetRestful.isRootResource(componentClass)) continue;
            if (component instanceof SessionBeanComponentDescription) {
                String jndiName;
                Class[] jaxrsType = GetRestful.getSubResourceClass(componentClass);
                if (component.getViews().size() == 1) {
                    jndiName = "java:app/" + moduleDescription.getModuleName() + "/" + componentClass.getSimpleName();
                } else {
                    boolean found = false;
                    String foundType = null;
                    for (ViewDescription view : component.getViews()) {
                        for (Class subResource : jaxrsType) {
                            if (!view.getViewClassName().equals(subResource.getName())) continue;
                            foundType = subResource.getName();
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) {
                        throw JaxrsMessages.MESSAGES.typeNameNotAnEjbView(Arrays.asList(jaxrsType), component.getComponentName());
                    }
                    jndiName = "java:app/" + moduleDescription.getModuleName() + "/" + componentClass.getSimpleName() + "!" + foundType;
                }
                JaxrsLogger.JAXRS_LOGGER.debugf("Found JAX-RS Managed Bean: %s local jndi jaxRsTypeName: %s", component.getComponentClassName(), jndiName);
                StringBuilder buf = new StringBuilder();
                buf.append(jndiName).append(";").append(component.getComponentClassName()).append(";").append("true");
                resteasy.getScannedJndiComponentResources().add(buf.toString());
                resteasy.getScannedResourceClasses().remove(component.getComponentClassName());
                continue;
            }
            if (!(component instanceof ManagedBeanComponentDescription)) continue;
            String jndiName = "java:app/" + moduleDescription.getModuleName() + "/" + component.getComponentName();
            JaxrsLogger.JAXRS_LOGGER.debugf("Found JAX-RS Managed Bean: %s local jndi name: %s", component.getComponentClassName(), jndiName);
            StringBuilder buf = new StringBuilder();
            buf.append(jndiName).append(";").append(component.getComponentClassName()).append(";").append("true");
            resteasy.getScannedJndiComponentResources().add(buf.toString());
            resteasy.getScannedResourceClasses().remove(component.getComponentClassName());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

