/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JdrReportDescriptions {
    private static final String RESOURCE_NAME = JdrReportDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getJdrSubsystemDescription(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("description").set(bundle2.getString("jdr.subsystem"));
        result.get("operations");
        result.get("children");
        return result;
    }

    public static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("add");
        result.get("description").set(bundle2.getString("jdr.add"));
        result.get("request-properties").setEmptyObject();
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    public static ModelNode getSubsystemRemove(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("remove");
        result.get("description").set(bundle2.getString("jdr.remove"));
        result.get("request-properties").setEmptyObject();
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    public static ModelNode getJdrRequestDescription(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("generate-jdr-report");
        result.get("description").set(bundle2.getString("jdr.request"));
        result.get("request-properties").setEmptyObject();
        result.get(new String[]{"reply-properties", "start-time", "description"}).set(bundle2.getString("jdr.report.starttime"));
        result.get(new String[]{"reply-properties", "start-time", "type"}).set(ModelType.STRING);
        result.get(new String[]{"reply-properties", "start-time", "required"}).set(true);
        result.get(new String[]{"reply-properties", "end-time", "description"}).set(bundle2.getString("jdr.report.endtime"));
        result.get(new String[]{"reply-properties", "end-time", "type"}).set(ModelType.STRING);
        result.get(new String[]{"reply-properties", "end-time", "required"}).set(true);
        result.get(new String[]{"reply-properties", "report-location", "description"}).set(bundle2.getString("jdr.report.location"));
        result.get(new String[]{"reply-properties", "report-location", "type"}).set(ModelType.STRING);
        result.get(new String[]{"reply-properties", "report-location", "required"}).set(false);
        return result;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

