/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.jmx.Attribute;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMXConnectorElement
extends AbstractModelElement<JMXConnectorElement> {
    private static final long serialVersionUID = 1504432525621055179L;
    private String serverBinding;
    private String registryBinding;

    public JMXConnectorElement(String serverBinding, String registryBinding) {
        if (serverBinding == null) {
            throw new IllegalArgumentException("null connector binding");
        }
        if (registryBinding == null) {
            throw new IllegalArgumentException("null registry binding");
        }
        this.serverBinding = serverBinding;
        this.registryBinding = registryBinding;
    }

    public String getServerBinding() {
        return this.serverBinding;
    }

    public String getRegistryBinding() {
        return this.registryBinding;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        this.writeAttributes(streamWriter);
        streamWriter.writeEndElement();
    }

    void writeAttributes(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.REGISTRY_BINDING.getLocalName(), this.registryBinding);
        streamWriter.writeAttribute(Attribute.SERVER_BINDING.getLocalName(), this.serverBinding);
    }

    protected Class<JMXConnectorElement> getElementClass() {
        return JMXConnectorElement.class;
    }
}

