/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.jmx.Element;
import org.jboss.as.jmx.JMXConnectorAdd;
import org.jboss.as.jmx.JMXConnectorElement;
import org.jboss.as.jmx.JmxSubsystemAdd;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.Namespace;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class JmxSubsystemElement
extends AbstractSubsystemElement<JmxSubsystemElement> {
    private static final long serialVersionUID = 4808972600600585073L;
    private JMXConnectorElement connector;

    public JmxSubsystemElement() {
        super(Namespace.JMX_1_0.getUriString());
    }

    protected Class<JmxSubsystemElement> getElementClass() {
        return JmxSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.connector != null) {
            streamWriter.writeEmptyElement(Element.JMX_CONNECTOR.getLocalName());
            this.connector.writeAttributes(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<JmxSubsystemElement, ?>> list) {
        if (this.connector != null) {
            list.add(new JMXConnectorAdd(this.connector.getServerBinding(), this.connector.getRegistryBinding()));
        }
    }

    protected boolean isEmpty() {
        return true;
    }

    protected JmxSubsystemAdd getAdd() {
        return new JmxSubsystemAdd();
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceContainer container = updateContext.getServiceContainer();
        ServiceController service = container.getService(MBeanServerService.SERVICE_NAME);
        if (service != null) {
            service.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public JMXConnectorElement getConnector() {
        return this.connector;
    }

    public void setConnector(JMXConnectorElement connector) {
        this.connector = connector;
    }
}

