/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.jmx.Attribute;
import org.jboss.as.jmx.Element;
import org.jboss.as.jmx.JMXConnectorAdd;
import org.jboss.as.jmx.JmxSubsystemAdd;
import org.jboss.as.jmx.JmxSubsystemElement;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class JmxSubsystemElementParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<JmxSubsystemElement>>> {
    JmxSubsystemElementParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<JmxSubsystemElement>> result) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JMX_CONNECTOR: {
                    JmxSubsystemElementParser.parseConnector(reader, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)new JmxSubsystemAdd(), updates));
    }

    static void parseConnector(XMLExtendedStreamReader reader, List<AbstractSubsystemUpdate<JmxSubsystemElement, ?>> updates) throws XMLStreamException {
        String serverBinding = null;
        String registryBinding = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SERVER_BINDING: {
                    serverBinding = value;
                    continue block4;
                }
                case REGISTRY_BINDING: {
                    registryBinding = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (serverBinding == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SERVER_BINDING));
        }
        if (registryBinding == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REGISTRY_BINDING));
        }
        updates.add(new JMXConnectorAdd(serverBinding, registryBinding));
    }
}

