/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class MBeanRegistrationService<T>
implements Service<Void> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jmx");
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "registration"});
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final InjectedValue<T> value = new InjectedValue();
    private final String name;
    private ObjectName objectName;

    public MBeanRegistrationService(String name) {
        this.name = name;
    }

    public MBeanRegistrationService(String name, Value<T> value) {
        this.name = name;
        this.value.inject(value.getValue());
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mBeanServer = this.getMBeanServer();
        Object value = this.value.getValue();
        try {
            this.objectName = new ObjectName(this.name);
        }
        catch (MalformedObjectNameException e) {
            throw new StartException("Failed to register mbean [" + this.name + "]", (Throwable)e);
        }
        try {
            log.debugf("Registering [%s] with name [%s]", value, (Object)this.objectName);
            mBeanServer.registerMBean(value, this.objectName);
        }
        catch (Exception e) {
            throw new StartException("Failed to register mbean [" + this.name + "]", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.objectName == null) {
            log.warn((Object)"No ObjectName available to unregister");
        }
        MBeanServer mBeanServer = this.getMBeanServer();
        try {
            mBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to unregister [%s]", (Object)this.objectName);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<MBeanServer> getMBeanServerInjector() {
        return this.injectedMBeanServer;
    }

    public Injector<T> getValueInjector() {
        return this.value;
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mBeanServer = (MBeanServer)this.injectedMBeanServer.getOptionalValue();
        if (mBeanServer == null) {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mBeanServer;
    }
}

