/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.jpa.transaction.TransactionLocalDelegateImpl;

public class TransactionLocal {
    private static final Object NULL_VALUE = new Object();
    private static volatile TransactionManager transactionManager;
    private static volatile TransactionLocalDelegateImpl delegate;

    public static void setTransactionManager(TransactionManager tm) {
        if (transactionManager == null) {
            transactionManager = tm;
            delegate = new TransactionLocalDelegateImpl(tm);
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public TransactionLocal() {
    }

    public TransactionLocal(TransactionManager tm) {
        if (tm == null) {
            throw new IllegalArgumentException("Null transaction manager");
        }
        transactionManager = tm;
        delegate = new TransactionLocalDelegateImpl(tm);
    }

    public void lock() throws InterruptedException {
        this.lock(this.getTransaction());
    }

    public void lock(Transaction transaction) throws InterruptedException {
        if (transaction == null) {
            return;
        }
        delegate.lock(this, transaction);
    }

    public void unlock() {
        this.unlock(this.getTransaction());
    }

    public void unlock(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        delegate.unlock(this, transaction);
    }

    protected Object initialValue() {
        return null;
    }

    protected Object getValue(Transaction tx) {
        return delegate.getValue(this, tx);
    }

    protected void storeValue(Transaction tx, Object value) {
        delegate.storeValue(this, tx, value);
    }

    protected boolean containsValue(Transaction tx) {
        return delegate.containsValue(this, tx);
    }

    public Object get() {
        return this.get(this.getTransaction());
    }

    public Object get(Transaction transaction) {
        if (transaction == null) {
            return this.initialValue();
        }
        Object value = this.getValue(transaction);
        if (value == null) {
            value = this.initialValue();
            if (value == null) {
                value = NULL_VALUE;
            }
            try {
                this.storeValue(transaction, value);
            }
            catch (IllegalStateException e) {
                return this.initialValue();
            }
        }
        if (value == NULL_VALUE) {
            return null;
        }
        return value;
    }

    public void set(Object value) {
        this.set(this.getTransaction(), value);
    }

    public void set(Transaction transaction, Object value) {
        if (transaction == null) {
            throw new IllegalStateException("there is no transaction");
        }
        if (!this.containsValue(transaction)) {
            this.initialValue();
        }
        if (value == null) {
            value = NULL_VALUE;
        }
        this.storeValue(transaction, value);
    }

    public Transaction getTransaction() {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("An error occured while getting the transaction associated with the current thread: " + (Object)((Object)e));
        }
    }
}

