/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.puparser.PersistenceUnitXmlParser;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.metadata.parser.util.NoopXmlResolver;
import org.jboss.vfs.VirtualFile;

public class PersistenceUnitParseProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_PERSISTENCE_XML = "WEB-INF/classes/META-INF/persistence.xml";
    private static final String META_INF_PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        this.handleWarDeployment(phaseContext);
        this.handleEarDeployment(phaseContext);
        this.handleJarDeployment(phaseContext);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void handleJarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!PersistenceUnitParseProcessor.isEarDeployment(deploymentUnit) && !PersistenceUnitParseProcessor.isWarDeployment(deploymentUnit)) {
            ArrayList<PersistenceUnitMetadataHolder> listPUHolders = new ArrayList<PersistenceUnitMetadataHolder>(1);
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile persistence_xml = deploymentRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
            this.parse(persistence_xml, listPUHolders, deploymentUnit, deploymentRoot);
            PersistenceUnitMetadataHolder holder = this.normalize(listPUHolders);
            deploymentRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
            this.markDU(holder, deploymentUnit);
            log.trace((Object)("parsed persistence unit definitions for jar " + deploymentRoot.getRootName()));
        }
    }

    private void handleWarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitParseProcessor.isWarDeployment(deploymentUnit)) {
            ResourceRoot deploymentRoot;
            ArrayList<PersistenceUnitMetadataHolder> listPUHolders = new ArrayList<PersistenceUnitMetadataHolder>(1);
            ResourceRoot classesRoot = deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            for (ResourceRoot resourceRoot : deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) {
                if (!ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || !resourceRoot.getRoot().getPathName().contains("WEB-INF/classes")) continue;
                classesRoot = resourceRoot;
                break;
            }
            VirtualFile persistence_xml = deploymentRoot.getRoot().getChild(WEB_PERSISTENCE_XML);
            this.parse(persistence_xml, listPUHolders, deploymentUnit, classesRoot);
            PersistenceUnitMetadataHolder holder = this.normalize(listPUHolders);
            deploymentRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
            this.markDU(holder, deploymentUnit);
            List resourceRoots = (List)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
            assert (resourceRoots != null);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!resourceRoot.getRoot().getLowerCaseName().endsWith(".jar")) continue;
                listPUHolders = new ArrayList(1);
                persistence_xml = resourceRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
                this.parse(persistence_xml, listPUHolders, deploymentUnit, resourceRoot);
                holder = this.normalize(listPUHolders);
                resourceRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
                this.markDU(holder, deploymentUnit);
            }
            log.trace((Object)("parsed persistence unit definitions for war " + deploymentRoot.getRootName()));
        }
    }

    private void handleEarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitParseProcessor.isEarDeployment(deploymentUnit)) {
            ArrayList<PersistenceUnitMetadataHolder> listPUHolders = new ArrayList<PersistenceUnitMetadataHolder>(1);
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile persistence_xml = deploymentRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
            this.parse(persistence_xml, listPUHolders, deploymentUnit, deploymentRoot);
            PersistenceUnitMetadataHolder holder = this.normalize(listPUHolders);
            deploymentRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
            this.markDU(holder, deploymentUnit);
            log.trace((Object)("parsed persistence unit definitions for ear " + deploymentRoot.getRootName()));
        }
    }

    private void parse(VirtualFile persistence_xml, List<PersistenceUnitMetadataHolder> listPUHolders, DeploymentUnit deploymentUnit, ResourceRoot deploymentRoot) throws DeploymentUnitProcessingException {
        if (persistence_xml.exists() && persistence_xml.isFile()) {
            InputStream is = null;
            try {
                is = persistence_xml.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXmlResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                PersistenceUnitMetadataHolder puHolder = PersistenceUnitXmlParser.parse(xmlReader);
                this.postParseSteps(persistence_xml, puHolder, deploymentUnit, deploymentRoot);
                listPUHolders.add(puHolder);
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse " + persistence_xml, (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    private void postParseSteps(VirtualFile persistence_xml, PersistenceUnitMetadataHolder puHolder, DeploymentUnit deploymentUnit, ResourceRoot resourceRoot) {
        Index index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
        for (PersistenceUnitMetadata pu : puHolder.getPersistenceUnits()) {
            ArrayList<URL> jarfilesUrls = new ArrayList<URL>();
            if (pu.getJarFiles() != null) {
                for (String jar : pu.getJarFiles()) {
                    jarfilesUrls.add(PersistenceUnitParseProcessor.getRelativeURL(persistence_xml, jar));
                }
            }
            pu.setJarFileUrls(jarfilesUrls);
            URL url = this.getPersistenceUnitURL(persistence_xml);
            pu.setPersistenceUnitRootUrl(url);
            pu.setScopedPersistenceUnitName(PersistenceUnitParseProcessor.createBeanName(deploymentUnit, pu.getPersistenceUnitName()));
            pu.setAnnotationIndex(index);
        }
    }

    private static URL getRelativeURL(VirtualFile persistence_xml, String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                VirtualFile deploymentUnitFile = persistence_xml;
                VirtualFile parent = deploymentUnitFile.getParent();
                VirtualFile baseDir = parent != null ? parent : deploymentUnitFile;
                VirtualFile jarFile = baseDir.getChild(jar);
                if (jarFile == null) {
                    throw new RuntimeException("could not find child '" + jar + "' on '" + baseDir + "'");
                }
                return jarFile.toURL();
            }
            catch (Exception e1) {
                throw new RuntimeException("could not find relative path: " + jar, e1);
            }
        }
    }

    protected URL getPersistenceUnitURL(VirtualFile persistence_xml) {
        try {
            VirtualFile metaData = persistence_xml;
            return metaData.getParent().getParent().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PersistenceUnitMetadataHolder normalize(List<PersistenceUnitMetadataHolder> listPUHolders) {
        HashMap<String, PersistenceUnitMetadata> flattened = new HashMap<String, PersistenceUnitMetadata>();
        for (PersistenceUnitMetadataHolder puHolder : listPUHolders) {
            for (PersistenceUnitMetadata pu : puHolder.getPersistenceUnits()) {
                if (!flattened.containsKey(pu.getPersistenceUnitName())) {
                    flattened.put(pu.getPersistenceUnitName(), pu);
                    continue;
                }
                PersistenceUnitMetadata first = (PersistenceUnitMetadata)flattened.get(pu.getPersistenceUnitName());
                PersistenceUnitMetadata duplicate = pu;
                log.warn((Object)("duplicate Persistence Unit definition for " + duplicate.getPersistenceUnitName() + " in application.  One of the duplicate persistence.xml should be removed from the application." + " Application deployment will continue with the persistence.xml definitions from " + first.getScopedPersistenceUnitName() + " used.  The persistence.xml definitions from " + duplicate.getScopedPersistenceUnitName() + " will be ignored."));
            }
        }
        PersistenceUnitMetadataHolder holder = new PersistenceUnitMetadataHolder();
        holder.setPersistenceUnits(new ArrayList<PersistenceUnitMetadata>(flattened.values()));
        return holder;
    }

    static boolean isEarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context);
    }

    static boolean isWarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)context);
    }

    private static String getScopedDeploymentUnitPath(DeploymentUnit deploymentUnit) {
        ArrayList<String> parts = new ArrayList<String>();
        do {
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            DeploymentUnit parentdeploymentUnit = deploymentUnit.getParent();
            if (parentdeploymentUnit != null) {
                ResourceRoot parentDeploymentRoot = (ResourceRoot)parentdeploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                parts.add(0, deploymentRoot.getRoot().getPathNameRelativeTo(parentDeploymentRoot.getRoot()));
                continue;
            }
            parts.add(0, deploymentRoot.getRoot().getName());
        } while ((deploymentUnit = deploymentUnit.getParent()) != null);
        StringBuilder result = new StringBuilder();
        boolean needSeparator = false;
        for (String part : parts) {
            if (needSeparator) {
                result.append('/');
            }
            result.append(part);
            needSeparator = true;
        }
        return result.toString();
    }

    public static String createBeanName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        if (persistenceUnitName.indexOf(47) != -1) {
            throw new IllegalArgumentException("persistence unit name (" + persistenceUnitName + ") contains illegal '/' character");
        }
        if (persistenceUnitName.indexOf(35) != -1) {
            throw new IllegalArgumentException("persistence unit name (" + persistenceUnitName + ") contains illegal '#' character");
        }
        String unitName = PersistenceUnitParseProcessor.getScopedDeploymentUnitPath(deploymentUnit) + "#" + persistenceUnitName;
        return unitName;
    }

    private void markDU(PersistenceUnitMetadataHolder holder, DeploymentUnit deploymentUnit) {
        if (holder.getPersistenceUnits() != null && holder.getPersistenceUnits().size() > 0) {
            JPADeploymentMarker.mark(deploymentUnit);
        }
    }
}

