/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.as.jpa.container.NonTxEmCloser;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class TransactionScopedEntityManager
extends AbstractEntityManager {
    private final String puScopedName;
    private final Map properties;
    private final EntityManagerFactory emf;

    public TransactionScopedEntityManager(String puScopedName, Map properties, EntityManagerFactory emf) {
        super(puScopedName, false);
        this.puScopedName = puScopedName;
        this.properties = properties;
        this.emf = emf;
    }

    @Override
    protected EntityManager getEntityManager() {
        EntityManager result;
        boolean isInTx = TransactionUtil.getInstance().isInTx();
        if (isInTx) {
            result = TransactionUtil.getInstance().getOrCreateTransactionScopedEntityManager(this.emf, this.puScopedName, this.properties);
        } else {
            result = NonTxEmCloser.get(this.puScopedName);
            if (result == null) {
                result = EntityManagerUtil.createEntityManager(this.emf, this.properties);
                NonTxEmCloser.add(this.puScopedName, result);
            }
        }
        return result;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return false;
    }

    @Override
    protected boolean isInTx() {
        return TransactionUtil.getInstance().isInTx();
    }

    @Override
    public void close() {
        throw new IllegalStateException("Container managed entity manager can only be closed by the container (auto-cleared at tx/invocation end and closed when owning component is closed.)");
    }
}

