/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PersistenceUnitService
implements Service<PersistenceUnitService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"persistenceunit"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");
    private final InjectedValue<Map> properties = new InjectedValue();
    private final InjectedValue<DataSource> jtaDataSource = new InjectedValue();
    private final InjectedValue<DataSource> nonJtaDataSource = new InjectedValue();
    private final PersistenceProviderAdaptor persistenceProviderAdaptor;
    private final PersistenceProvider persistenceProvider;
    private final PersistenceUnitMetadata pu;
    private volatile EntityManagerFactory entityManagerFactory;

    public PersistenceUnitService(PersistenceUnitMetadata pu, PersistenceProviderAdaptor persistenceProviderAdaptor, PersistenceProvider persistenceProvider) {
        this.pu = pu;
        this.persistenceProviderAdaptor = persistenceProviderAdaptor;
        this.persistenceProvider = persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            log.infof("starting Persistence Unit Service '%s' ", (Object)this.pu.getScopedPersistenceUnitName());
            this.pu.setJtaDataSource((DataSource)this.jtaDataSource.getOptionalValue());
            this.pu.setNonJtaDataSource((DataSource)this.nonJtaDataSource.getOptionalValue());
            this.entityManagerFactory = this.createContainerEntityManagerFactory();
        }
        finally {
            this.pu.setTempClassloader(null);
        }
    }

    public void stop(StopContext context) {
        log.infof("stopping Persistence Unit Service '%s' ", (Object)this.pu.getScopedPersistenceUnitName());
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
            this.entityManagerFactory = null;
        }
    }

    public PersistenceUnitService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public Injector<Map> getPropertiesInjector() {
        return this.properties;
    }

    public Injector<DataSource> getJtaDataSourceInjector() {
        return this.jtaDataSource;
    }

    public Injector<DataSource> getNonJtaDataSourceInjector() {
        return this.nonJtaDataSource;
    }

    public static ServiceName getPUServiceName(PersistenceUnitMetadata pu) {
        return SERVICE_NAME.append(new String[]{pu.getScopedPersistenceUnitName()});
    }

    public static ServiceName getPUServiceName(String scopedPersistenceUnitName) {
        return SERVICE_NAME.append(new String[]{scopedPersistenceUnitName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createContainerEntityManagerFactory() {
        this.persistenceProviderAdaptor.beforeCreateContainerEntityManagerFactory(this.pu);
        try {
            EntityManagerFactory entityManagerFactory = this.persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.pu, (Map)this.properties.getValue());
            return entityManagerFactory;
        }
        finally {
            try {
                this.persistenceProviderAdaptor.afterCreateContainerEntityManagerFactory(this.pu);
            }
            finally {
                this.pu.setAnnotationIndex(null);
                this.pu.setTempClassloader(null);
            }
        }
    }
}

