/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.logging.AbstractLoggerAdd;
import org.jboss.as.logging.AbstractLoggerElement;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerElement;
import org.jboss.as.logging.LoggerService;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class LoggerAdd
extends AbstractLoggerAdd {
    private static final long serialVersionUID = 4230922005791983261L;
    private final String name;
    private boolean useParentHandlers = true;

    public LoggerAdd(String name, boolean useParentHandlers) {
        this.name = name;
        this.useParentHandlers = useParentHandlers;
    }

    public LoggerAdd(String name) {
        this.name = name;
    }

    @Override
    protected AbstractLoggerElement<?> addNewElement(LoggingSubsystemElement element) throws UpdateFailedException {
        LoggerElement newElement = new LoggerElement(this.name);
        newElement.setUseParentHandlers(this.useParentHandlers);
        if (!element.addLogger(newElement)) {
            throw new UpdateFailedException("Logger " + this.name + " already exists");
        }
        return newElement;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        try {
            String loggerName = this.getLoggerName();
            LoggerService service = new LoggerService(loggerName);
            service.setLevel(Level.parse(this.getLevelName()));
            BatchBuilder batchBuilder = updateContext.getBatchBuilder();
            BatchServiceBuilder builder = batchBuilder.addService(LogServices.loggerName(loggerName), (Service)service);
            builder.setInitialMode(ServiceController.Mode.ACTIVE);
            builder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param));
        }
        catch (Throwable t) {
            resultHandler.handleFailure(t, param);
            return;
        }
    }

    public boolean isUseParentHandlers() {
        return this.useParentHandlers;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    @Override
    public String getLoggerName() {
        return this.name;
    }
}

