/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerHandlerType;
import org.jboss.as.logging.LoggingSubsystemProviders;
import org.jboss.as.logging.OverflowAction;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

class AsyncHandlerAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final AsyncHandlerAdd INSTANCE = new AsyncHandlerAdd();
    static final String OPERATION_NAME = "add-async-handler";

    AsyncHandlerAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("remove");
        String handlerType = operation.require("handler-type").asString();
        LoggerHandlerType type = LoggerHandlerType.valueOf(handlerType);
        if (type != LoggerHandlerType.ASYNC_HANDLER) {
            throw new OperationFailedException(new ModelNode().set("invalid operation for handler-type: " + (Object)((Object)type)));
        }
        ModelNode subModel = context.getSubModel();
        subModel.get("handler-type").set(handlerType);
        subModel.get("queue-length").set(operation.get("queue-length"));
        subModel.get("subhandlers").set(operation.get("subhandlers"));
        subModel.get("level").set(operation.get("level"));
        subModel.get("overflow-action").set(operation.get("overflow-action"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    try {
                        AsyncHandlerService service = new AsyncHandlerService();
                        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
                        ArrayList<InjectedValue<Handler>> list = new ArrayList<InjectedValue<Handler>>();
                        for (ModelNode handlerName : operation.get("subhandlers").asList()) {
                            InjectedValue injectedValue = new InjectedValue();
                            serviceBuilder.addDependency(LogServices.handlerName(handlerName.asString()), Handler.class, (Injector)injectedValue);
                            list.add((InjectedValue<Handler>)injectedValue);
                        }
                        service.addHandlers(list);
                        if (operation.hasDefined("queue-length")) {
                            service.setQueueLength(operation.get("queue-length").asInt());
                        }
                        service.setLevel(Level.parse(operation.get("level").asString()));
                        service.setOverflowAction(OverflowAction.valueOf(operation.get("overflow-action").asString()));
                        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
                        serviceBuilder.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                        serviceBuilder.install();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return LoggingSubsystemProviders.getAsyncModelDescription(locale);
    }
}

