/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.RootLoggerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class RootLoggerAdd
implements ModelUpdateOperationHandler {
    static final RootLoggerAdd INSTANCE = new RootLoggerAdd();
    static final String OPERATION_NAME = "set-root-logger";

    RootLoggerAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("remove-root-logger");
        final String level = operation.require("level").asString();
        final ModelNode handlers = operation.get("handlers");
        ModelNode subModel = context.getSubModel();
        subModel.get(new String[]{"root-logger", "level"}).set(level);
        subModel.get(new String[]{"root-logger", "handlers"}).set(handlers);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    try {
                        RootLoggerService service = new RootLoggerService();
                        service.setLevel(Level.parse(level));
                        target.addService(LogServices.ROOT_LOGGER, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                    try {
                        if (handlers.getType() != ModelType.UNDEFINED) {
                            LogServices.installLoggerHandlers(target, "", handlers);
                        }
                        resultHandler.handleResultComplete();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

