/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Level;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.CustomHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingValidators;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class CustomHandlerAdd
extends AbstractAddStepHandler {
    static final CustomHandlerAdd INSTANCE = new CustomHandlerAdd();

    CustomHandlerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        LoggingValidators.validate(operation);
        model.get("encoding").set(operation.get("encoding"));
        model.get("formatter").set(operation.get("formatter"));
        if (operation.hasDefined("level")) {
            model.get("level").set(operation.get("level"));
        }
        model.get("module").set(operation.get("module"));
        model.get("class").set(operation.get("class"));
        if (operation.hasDefined("properties")) {
            model.get("properties").set(operation.get("properties"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        String className = operation.get("class").asString();
        String moduleName = operation.get("module").asString();
        CustomHandlerService service = new CustomHandlerService(className, moduleName);
        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
        try {
            if (operation.hasDefined("level")) {
                service.setLevel(Level.parse(operation.get("level").asString()));
            }
            if (operation.hasDefined("encoding")) {
                service.setEncoding(operation.get("encoding").asString());
            }
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
        if (operation.hasDefined("properties")) {
            service.addProperties(operation.get("properties").asPropertyList());
        }
        service.setFormatterSpec(AbstractFormatterSpec.Factory.create(operation));
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(serviceBuilder.install());
    }
}

