/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractLoggerService;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class LoggerService
extends AbstractLoggerService {
    private boolean useParentHandlers = true;
    private Level level;
    private Handler[] saved;

    protected LoggerService(String name) {
        super(name);
    }

    @Override
    protected synchronized void start(StartContext context, Logger logger) throws StartException {
        logger.setLevel(this.level);
        logger.setUseParentHandlers(this.useParentHandlers);
        this.saved = logger.clearHandlers();
    }

    @Override
    protected synchronized void stop(StopContext context, Logger logger) {
        logger.setLevel(null);
        logger.setUseParentHandlers(true);
        logger.clearHandlers();
        for (Handler handler : this.saved) {
            logger.addHandler(handler);
        }
    }

    public synchronized boolean isUseParentHandlers() {
        return this.useParentHandlers;
    }

    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.setUseParentHandlers(useParentHandlers);
        }
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.setLevel(level);
        }
    }
}

