/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class LoggerUnassignHandler
extends AbstractModelUpdateHandler {
    private static final String OPERATION_NAME = "unassign-handler";
    private static final LoggerUnassignHandler INSTANCE = new LoggerUnassignHandler();

    public static String getOperationName() {
        return OPERATION_NAME;
    }

    public static LoggerUnassignHandler getInstance() {
        return INSTANCE;
    }

    protected String getHandlerName(ModelNode operation) {
        return this.getHandlerNameNode(operation).asString();
    }

    protected ModelNode getHandlerNameNode(ModelNode operation) {
        return operation.get("name");
    }

    protected String getLoggerName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.getLastElement().getValue();
    }

    protected void opFailed(String description) throws OperationFailedException {
        ModelNode failure = new ModelNode();
        failure.get(new String[]{"failure-description", description});
        throw new OperationFailedException(failure);
    }

    protected ModelNode getAssignedHandlers(ModelNode updateableModel) {
        return updateableModel.get("handlers");
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String loggerName = this.getLoggerName(operation);
        String handlerName = this.getHandlerName(operation);
        context.removeService(LogServices.loggerHandlerName(loggerName, handlerName));
    }

    protected ModelNode getTargetModel(ModelNode model) {
        return model;
    }

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String handlerName = this.getHandlerName(operation);
        ModelNode handlerNameNode = this.getHandlerNameNode(operation);
        ModelNode targetModel = this.getTargetModel(model);
        ModelNode assignedHandlers = this.getAssignedHandlers(targetModel);
        if (!assignedHandlers.isDefined() || !assignedHandlers.asList().contains(handlerNameNode)) {
            this.opFailed("Can not unassign handler.  Handler " + handlerName + " is not assigned.");
        }
        ArrayList<ModelNode> newList = new ArrayList<ModelNode>();
        for (ModelNode node : assignedHandlers.asList()) {
            if (node.asString().equals(handlerName)) continue;
            newList.add(node);
        }
        targetModel.get("handlers").set(newList);
    }
}

