/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Collection;
import java.util.logging.Level;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingValidators;
import org.jboss.as.logging.RootLoggerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class RootLoggerAdd
implements OperationStepHandler {
    static final RootLoggerAdd INSTANCE = new RootLoggerAdd();
    static final String OPERATION_NAME = "set-root-logger";

    RootLoggerAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) {
        final String level = operation.require("level").asString();
        final ModelNode handlers = operation.get("handlers");
        ModelNode subModel = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        subModel.get(new String[]{"root-logger", "level"}).set(level);
        subModel.get(new String[]{"root-logger", "handlers"}).set(handlers);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    LoggingValidators.validate(operation);
                    ServiceTarget target = context.getServiceTarget();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    try {
                        RootLoggerService service = new RootLoggerService();
                        if (operation.hasDefined("level")) {
                            service.setLevel(Level.parse(level));
                        }
                        target.addService(LogServices.ROOT_LOGGER, (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                    Collection<ServiceController<?>> loggerControllers = null;
                    try {
                        if (handlers.getType() != ModelType.UNDEFINED) {
                            loggerControllers = LogServices.installLoggerHandlers(target, "", handlers, verificationHandler);
                        }
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.removeService(LogServices.ROOT_LOGGER);
                        if (loggerControllers != null) {
                            for (ServiceController<?> loggerController : loggerControllers) {
                                context.removeService(loggerController.getName());
                            }
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

