/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.handlers.AsyncHandler;

final class OverflowActionValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final EnumSet<AsyncHandler.OverflowAction> allowedValues = EnumSet.allOf(AsyncHandler.OverflowAction.class);

    public OverflowActionValidator(boolean nullable) {
        this(nullable, false);
    }

    public OverflowActionValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String oaString = value.asString();
            try {
                AsyncHandler.OverflowAction overflowAction = ModelParser.parseOverflowAction(value);
                if (overflowAction == null || !this.allowedValues.contains(overflowAction)) {
                    throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidOverflowAction(oaString)));
                }
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidOverflowAction(oaString)));
            }
        }
    }

    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (AsyncHandler.OverflowAction oa : this.allowedValues) {
            result.add(new ModelNode().set(oa.name()));
        }
        return result;
    }
}

