/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.FlushingHandlerAddProperties;
import org.jboss.as.logging.handlers.file.FileHandlerService;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;

public class FileHandlerAdd
extends FlushingHandlerAddProperties<FileHandlerService> {
    public static final FileHandlerAdd INSTANCE = new FileHandlerAdd();

    private FileHandlerAdd() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.FILE});
    }

    @Override
    protected FileHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new FileHandlerService();
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, FileHandlerService service, ModelNode model) throws OperationFailedException {
        super.updateRuntime(context, serviceBuilder, name, service, model);
        ModelNode append = CommonAttributes.APPEND.resolveModelAttribute(context, model);
        if (append.isDefined()) {
            service.setAppend(append.asBoolean());
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode file = CommonAttributes.FILE.resolveModelAttribute(context, model);
        if (file.isDefined()) {
            FileHandlers.addFile(context, serviceBuilder, service, file, name);
        }
    }
}

