/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.custom;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.handlers.HandlerService;
import org.jboss.as.logging.handlers.custom.PropertiesConfigurator;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class CustomHandlerService
implements HandlerService {
    private final String className;
    private final String moduleName;
    private final List<Property> properties;
    private Filter filter;
    private FormatterSpec formatterSpec;
    private Level level;
    private String encoding;
    private Handler value;

    public CustomHandlerService(String className, String moduleName) {
        this.className = className;
        this.moduleName = moduleName;
        this.properties = new ArrayList<Property>();
    }

    public synchronized void start(StartContext context) throws StartException {
        Handler handler;
        ModuleLoader moduleLoader = Module.forClass(CustomHandlerService.class).getModuleLoader();
        ModuleIdentifier id = ModuleIdentifier.create((String)this.moduleName);
        try {
            Class<?> handlerClass = Class.forName(this.className, false, (ClassLoader)moduleLoader.loadModule(id).getClassLoader());
            if (!Handler.class.isAssignableFrom(handlerClass)) {
                throw LoggingMessages.MESSAGES.invalidType(this.className, Handler.class);
            }
            handler = (Handler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw LoggingMessages.MESSAGES.classNotFound(e, this.className);
        }
        catch (ModuleLoadException e) {
            throw LoggingMessages.MESSAGES.cannotLoadModule(e, this.moduleName);
        }
        catch (InstantiationException e) {
            throw LoggingMessages.MESSAGES.cannotInstantiateClass(e, this.className);
        }
        catch (IllegalAccessException e) {
            throw LoggingMessages.MESSAGES.cannotAccessClass(e, this.className);
        }
        if (this.filter != null) {
            handler.setFilter(this.filter);
        }
        this.formatterSpec.apply(handler);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        PropertiesConfigurator.setProperties(handler, this.properties);
        this.value = handler;
    }

    public synchronized void stop(StopContext context) {
        Handler handler = this.value;
        handler.close();
        this.properties.clear();
        this.value = null;
    }

    public synchronized void addProperty(Property property) {
        this.properties.add(property);
        Handler handler = this.value;
        if (handler != null) {
            PropertiesConfigurator.setProperties(handler, this.properties);
        }
    }

    public synchronized void addProperties(Collection<Property> properties) {
        this.properties.addAll(properties);
        Handler handler = this.value;
        if (handler != null) {
            PropertiesConfigurator.setProperties(handler, this.properties);
        }
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    @Override
    public synchronized void setLevel(Level level) {
        this.level = level;
        Handler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized FormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    @Override
    public synchronized void setFormatterSpec(FormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        Handler handler = this.value;
        if (handler != null) {
            formatterSpec.apply(handler);
        }
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
        Handler handler = this.value;
        if (handler != null) {
            handler.setFilter(filter);
        }
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    @Override
    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        Handler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
        this.encoding = encoding;
    }
}

