/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.dmr.ModelNode;

public class HandlerFileChange
implements OperationStepHandler {
    public static final String OPERATION_NAME = "change-file";
    public static final HandlerFileChange INSTANCE = new HandlerFileChange();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode originalModel = resource.getModel().clone();
        final ModelNode model = resource.getModel();
        CommonAttributes.FILE.validateAndSet(operation, model);
        if (context.getType() == OperationContext.Type.SERVER && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode file;
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    ModelNode oldFile = CommonAttributes.FILE.resolveModelAttribute(context, originalModel);
                    if (FileHandlers.changeFile(context, oldFile, file = CommonAttributes.FILE.resolveModelAttribute(context, model), name)) {
                        context.restartRequired();
                    }
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        FileHandlers.revertFileChange(context, CommonAttributes.FILE.resolveModelAttribute(context, originalModel), name);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

