/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingDescribeHandler;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.LoggingSubsystemProviders;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.handlers.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.HandlerDisable;
import org.jboss.as.logging.handlers.HandlerEnable;
import org.jboss.as.logging.handlers.HandlerLevelChange;
import org.jboss.as.logging.handlers.LoggerHandlerRemove;
import org.jboss.as.logging.handlers.async.AsyncHandlerAdd;
import org.jboss.as.logging.handlers.async.AsyncHandlerAssignSubhandler;
import org.jboss.as.logging.handlers.async.AsyncHandlerUnassignSubhandler;
import org.jboss.as.logging.handlers.async.AsyncHandlerUpdateProperties;
import org.jboss.as.logging.handlers.async.AsyncHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.console.ConsoleHandlerAdd;
import org.jboss.as.logging.handlers.console.ConsoleHandlerUpdateProperties;
import org.jboss.as.logging.handlers.console.ConsoleHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.custom.CustomHandlerAdd;
import org.jboss.as.logging.handlers.custom.CustomHandlerUpdateProperties;
import org.jboss.as.logging.handlers.custom.CustomHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.file.FileHandlerAdd;
import org.jboss.as.logging.handlers.file.FileHandlerUpdateProperties;
import org.jboss.as.logging.handlers.file.FileHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.file.HandlerFileChange;
import org.jboss.as.logging.handlers.file.PeriodicHandlerUpdateProperties;
import org.jboss.as.logging.handlers.file.PeriodicHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.file.PeriodicRotatingFileHandlerAdd;
import org.jboss.as.logging.handlers.file.SizeRotatingFileHandlerAdd;
import org.jboss.as.logging.handlers.file.SizeRotatingHandlerUpdateProperties;
import org.jboss.as.logging.handlers.file.SizeRotatingHandlerWriteAttributeHandler;
import org.jboss.as.logging.loggers.AbstractLoggerWriteAttributeHandler;
import org.jboss.as.logging.loggers.LoggerAdd;
import org.jboss.as.logging.loggers.LoggerAssignHandler;
import org.jboss.as.logging.loggers.LoggerLevelChange;
import org.jboss.as.logging.loggers.LoggerRemove;
import org.jboss.as.logging.loggers.LoggerUnassignHandler;
import org.jboss.as.logging.loggers.LoggerWriteAttributeHandler;
import org.jboss.as.logging.loggers.RootLoggerAdd;
import org.jboss.as.logging.loggers.RootLoggerAssignHandler;
import org.jboss.as.logging.loggers.RootLoggerLevelChange;
import org.jboss.as.logging.loggers.RootLoggerRemove;
import org.jboss.as.logging.loggers.RootLoggerUnassignHandler;
import org.jboss.as.logging.loggers.RootLoggerWriteAttributeHandler;
import org.jboss.logmanager.ContextClassLoaderLogContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class LoggingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "logging";
    public static final PathElement rootLoggerPath = PathElement.pathElement((String)"root-logger", (String)"ROOT");
    private static final PathElement loggersPath = PathElement.pathElement((String)"logger");
    private static final PathElement asyncHandlersPath = PathElement.pathElement((String)"async-handler");
    private static final PathElement consoleHandlersPath = PathElement.pathElement((String)"console-handler");
    private static final PathElement customHandlerPath = PathElement.pathElement((String)"custom-handler");
    private static final PathElement fileHandlersPath = PathElement.pathElement((String)"file-handler");
    private static final PathElement periodicHandlersPath = PathElement.pathElement((String)"periodic-rotating-file-handler");
    private static final PathElement sizePeriodicHandlersPath = PathElement.pathElement((String)"size-rotating-file-handler");
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    static final ContextClassLoaderLogContextSelector CONTEXT_SELECTOR = new ContextClassLoaderLogContextSelector();

    public void initialize(ExtensionContext context) {
        LogContext.setLogContextSelector((LogContextSelector)CONTEXT_SELECTOR);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(LoggingSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)LoggingSubsystemAdd.ADD_INSTANCE, LoggingSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)LoggingDescribeHandler.INSTANCE, (DescriptionProvider)LoggingDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, LoggingSubsystemProviders.SUBSYSTEM_REMOVE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemParser.INSTANCE);
        ManagementResourceRegistration rootLogger = registration.registerSubModel(rootLoggerPath, LoggingSubsystemProviders.ROOT_LOGGER);
        rootLogger.registerOperationHandler("add", (OperationStepHandler)RootLoggerAdd.INSTANCE, LoggingSubsystemProviders.ADD_ROOT_LOGGER, false);
        rootLogger.registerOperationHandler("remove", (OperationStepHandler)RootLoggerRemove.INSTANCE, LoggingSubsystemProviders.REMOVE_ROOT_LOGGER, false);
        rootLogger.registerOperationHandler("set-root-logger", (OperationStepHandler)RootLoggerAdd.INSTANCE, LoggingSubsystemProviders.LEGACY_ADD_ROOT_LOGGER, false);
        rootLogger.registerOperationHandler("remove-root-logger", (OperationStepHandler)RootLoggerRemove.INSTANCE, LoggingSubsystemProviders.LEGACY_REMOVE_ROOT_LOGGER, false);
        rootLogger.registerOperationHandler("change-root-log-level", (OperationStepHandler)RootLoggerLevelChange.INSTANCE, LoggingSubsystemProviders.ROOT_LOGGER_CHANGE_LEVEL, false);
        rootLogger.registerOperationHandler("root-logger-assign-handler", (OperationStepHandler)RootLoggerAssignHandler.INSTANCE, LoggingSubsystemProviders.ROOT_LOGGER_ASSIGN_HANDLER, false);
        rootLogger.registerOperationHandler("root-logger-unassign-handler", (OperationStepHandler)RootLoggerUnassignHandler.INSTANCE, LoggingSubsystemProviders.ROOT_LOGGER_UNASSIGN_HANDLER, false);
        this.addWriteAttributes(rootLogger, RootLoggerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration loggers = registration.registerSubModel(loggersPath, LoggingSubsystemProviders.LOGGER);
        loggers.registerOperationHandler("add", (OperationStepHandler)LoggerAdd.INSTANCE, LoggingSubsystemProviders.LOGGER_ADD, false);
        loggers.registerOperationHandler("remove", (OperationStepHandler)LoggerRemove.INSTANCE, LoggingSubsystemProviders.LOGGER_REMOVE, false);
        loggers.registerOperationHandler("change-log-level", (OperationStepHandler)LoggerLevelChange.INSTANCE, LoggingSubsystemProviders.LOGGER_CHANGE_LEVEL, false);
        loggers.registerOperationHandler("assign-handler", (OperationStepHandler)LoggerAssignHandler.INSTANCE, LoggingSubsystemProviders.LOGGER_ASSIGN_HANDLER, false);
        loggers.registerOperationHandler("unassign-handler", (OperationStepHandler)LoggerUnassignHandler.INSTANCE, LoggingSubsystemProviders.LOGGER_UNASSIGN_HANDLER, false);
        this.addWriteAttributes(loggers, LoggerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration asyncHandler = registration.registerSubModel(asyncHandlersPath, LoggingSubsystemProviders.ASYNC_HANDLER);
        asyncHandler.registerOperationHandler("add", (OperationStepHandler)AsyncHandlerAdd.INSTANCE, LoggingSubsystemProviders.ASYNC_HANDLER_ADD, false);
        asyncHandler.registerOperationHandler("remove", (OperationStepHandler)LoggerHandlerRemove.ASYNC, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        asyncHandler.registerOperationHandler("enable", (OperationStepHandler)HandlerEnable.INSTANCE, LoggingSubsystemProviders.HANDLER_ENABLE, false);
        asyncHandler.registerOperationHandler("disable", (OperationStepHandler)HandlerDisable.INSTANCE, LoggingSubsystemProviders.HANDLER_DISABLE, false);
        asyncHandler.registerOperationHandler("change-log-level", (OperationStepHandler)HandlerLevelChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_LEVEL, false);
        asyncHandler.registerOperationHandler("update-properties", (OperationStepHandler)AsyncHandlerUpdateProperties.INSTANCE, LoggingSubsystemProviders.ASYNC_HANDLER_UPDATE, false);
        asyncHandler.registerOperationHandler("assign-subhandler", (OperationStepHandler)AsyncHandlerAssignSubhandler.INSTANCE, LoggingSubsystemProviders.ASYNC_HANDLER_ASSIGN_SUBHANDLER, false);
        asyncHandler.registerOperationHandler("unassign-subhandler", (OperationStepHandler)AsyncHandlerUnassignSubhandler.INSTANCE, LoggingSubsystemProviders.ASYNC_HANDLER_UNASSIGN_SUBHANDLER, false);
        this.addWriteAttributes(asyncHandler, AsyncHandlerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration consoleHandler = registration.registerSubModel(consoleHandlersPath, LoggingSubsystemProviders.CONSOLE_HANDLER);
        consoleHandler.registerOperationHandler("add", (OperationStepHandler)ConsoleHandlerAdd.INSTANCE, LoggingSubsystemProviders.CONSOLE_HANDLER_ADD, false);
        consoleHandler.registerOperationHandler("remove", (OperationStepHandler)LoggerHandlerRemove.CONSOLE, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        consoleHandler.registerOperationHandler("enable", (OperationStepHandler)HandlerEnable.INSTANCE, LoggingSubsystemProviders.HANDLER_ENABLE, false);
        consoleHandler.registerOperationHandler("disable", (OperationStepHandler)HandlerDisable.INSTANCE, LoggingSubsystemProviders.HANDLER_DISABLE, false);
        consoleHandler.registerOperationHandler("change-log-level", (OperationStepHandler)HandlerLevelChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_LEVEL, false);
        consoleHandler.registerOperationHandler("update-properties", (OperationStepHandler)ConsoleHandlerUpdateProperties.INSTANCE, LoggingSubsystemProviders.CONSOLE_HANDLER_UPDATE, false);
        this.addWriteAttributes(consoleHandler, ConsoleHandlerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration fileHandler = registration.registerSubModel(fileHandlersPath, LoggingSubsystemProviders.FILE_HANDLER);
        fileHandler.registerOperationHandler("add", (OperationStepHandler)FileHandlerAdd.INSTANCE, LoggingSubsystemProviders.FILE_HANDLER_ADD, false);
        fileHandler.registerOperationHandler("remove", (OperationStepHandler)LoggerHandlerRemove.FILE, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        fileHandler.registerOperationHandler("enable", (OperationStepHandler)HandlerEnable.INSTANCE, LoggingSubsystemProviders.HANDLER_ENABLE, false);
        fileHandler.registerOperationHandler("disable", (OperationStepHandler)HandlerDisable.INSTANCE, LoggingSubsystemProviders.HANDLER_DISABLE, false);
        fileHandler.registerOperationHandler("change-log-level", (OperationStepHandler)HandlerLevelChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_LEVEL, false);
        fileHandler.registerOperationHandler("change-file", (OperationStepHandler)HandlerFileChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_FILE, false);
        fileHandler.registerOperationHandler("update-properties", (OperationStepHandler)FileHandlerUpdateProperties.INSTANCE, LoggingSubsystemProviders.FILE_HANDLER_UPDATE, false);
        this.addWriteAttributes(fileHandler, FileHandlerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration periodicHandler = registration.registerSubModel(periodicHandlersPath, LoggingSubsystemProviders.PERIODIC_HANDLER);
        periodicHandler.registerOperationHandler("add", (OperationStepHandler)PeriodicRotatingFileHandlerAdd.INSTANCE, LoggingSubsystemProviders.PERIODIC_HANDLER_ADD, false);
        periodicHandler.registerOperationHandler("remove", (OperationStepHandler)LoggerHandlerRemove.PERIODIC_ROTATING_FILE, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        periodicHandler.registerOperationHandler("enable", (OperationStepHandler)HandlerEnable.INSTANCE, LoggingSubsystemProviders.HANDLER_ENABLE, false);
        periodicHandler.registerOperationHandler("disable", (OperationStepHandler)HandlerDisable.INSTANCE, LoggingSubsystemProviders.HANDLER_DISABLE, false);
        periodicHandler.registerOperationHandler("change-log-level", (OperationStepHandler)HandlerLevelChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_LEVEL, false);
        periodicHandler.registerOperationHandler("change-file", (OperationStepHandler)HandlerFileChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_FILE, false);
        periodicHandler.registerOperationHandler("update-properties", (OperationStepHandler)PeriodicHandlerUpdateProperties.INSTANCE, LoggingSubsystemProviders.PERIODIC_HANDLER_UPDATE, false);
        this.addWriteAttributes(periodicHandler, PeriodicHandlerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration sizePeriodicHandler = registration.registerSubModel(sizePeriodicHandlersPath, LoggingSubsystemProviders.SIZE_PERIODIC_HANDLER);
        sizePeriodicHandler.registerOperationHandler("add", (OperationStepHandler)SizeRotatingFileHandlerAdd.INSTANCE, LoggingSubsystemProviders.SIZE_PERIODIC_HANDLER_ADD, false);
        sizePeriodicHandler.registerOperationHandler("remove", (OperationStepHandler)LoggerHandlerRemove.SIZE_ROTATING_FILE, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        sizePeriodicHandler.registerOperationHandler("enable", (OperationStepHandler)HandlerEnable.INSTANCE, LoggingSubsystemProviders.HANDLER_ENABLE, false);
        sizePeriodicHandler.registerOperationHandler("disable", (OperationStepHandler)HandlerDisable.INSTANCE, LoggingSubsystemProviders.HANDLER_DISABLE, false);
        sizePeriodicHandler.registerOperationHandler("change-log-level", (OperationStepHandler)HandlerLevelChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_LEVEL, false);
        sizePeriodicHandler.registerOperationHandler("change-file", (OperationStepHandler)HandlerFileChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_FILE, false);
        sizePeriodicHandler.registerOperationHandler("update-properties", (OperationStepHandler)SizeRotatingHandlerUpdateProperties.INSTANCE, LoggingSubsystemProviders.SIZE_PERIODIC_HANDLER_UPDATE, false);
        this.addWriteAttributes(sizePeriodicHandler, SizeRotatingHandlerWriteAttributeHandler.INSTANCE);
        ManagementResourceRegistration customHandler = registration.registerSubModel(customHandlerPath, LoggingSubsystemProviders.CUSTOM_HANDLER);
        customHandler.registerOperationHandler("add", (OperationStepHandler)CustomHandlerAdd.INSTANCE, LoggingSubsystemProviders.CUSTOM_HANDLER_ADD, false);
        customHandler.registerOperationHandler("remove", (OperationStepHandler)LoggerHandlerRemove.CUSTOM, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        customHandler.registerOperationHandler("enable", (OperationStepHandler)HandlerEnable.INSTANCE, LoggingSubsystemProviders.HANDLER_ENABLE, false);
        customHandler.registerOperationHandler("disable", (OperationStepHandler)HandlerDisable.INSTANCE, LoggingSubsystemProviders.HANDLER_DISABLE, false);
        customHandler.registerOperationHandler("change-log-level", (OperationStepHandler)HandlerLevelChange.INSTANCE, LoggingSubsystemProviders.HANDLER_CHANGE_LEVEL, false);
        customHandler.registerOperationHandler("update-properties", (OperationStepHandler)CustomHandlerUpdateProperties.INSTANCE, LoggingSubsystemProviders.CUSTOM_HANDLER_UPDATE, false);
        this.addWriteAttributes(customHandler, CustomHandlerWriteAttributeHandler.INSTANCE);
        customHandler.registerReadWriteAttribute("properties", null, (OperationStepHandler)CustomHandlerWriteAttributeHandler.INSTANCE, EnumSet.of(AttributeAccess.Flag.RESTART_NONE));
        customHandler.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.CLASS, null);
        customHandler.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.MODULE, null);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.LOGGING_1_0.getUriString(), (XMLElementReader)LoggingSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.LOGGING_1_1.getUriString(), (XMLElementReader)LoggingSubsystemParser.INSTANCE);
    }

    private void addWriteAttributes(ManagementResourceRegistration handler, AbstractLogHandlerWriteAttributeHandler<?> stepHandler) {
        for (AttributeDefinition attr : stepHandler.getAttributes()) {
            handler.registerReadWriteAttribute(attr, null, stepHandler);
        }
    }

    private void addWriteAttributes(ManagementResourceRegistration handler, AbstractLoggerWriteAttributeHandler stepHandler) {
        for (AttributeDefinition attr : stepHandler.getAttributes()) {
            handler.registerReadWriteAttribute(attr, null, (OperationStepHandler)stepHandler);
        }
    }
}

