/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.handlers.console.Target;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final LoggingSubsystemParser INSTANCE = new LoggingSubsystemParser();

    private LoggingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "logging");
        address.protect();
        list.add(LoggingSubsystemAdd.createOperation(address));
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean gotRoot = false;
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: 
                case LOGGING_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOGGER: {
                            LoggingSubsystemParser.parseLoggerElement(reader, address, list, loggerNames);
                            continue block13;
                        }
                        case ROOT_LOGGER: {
                            if (gotRoot) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            gotRoot = true;
                            LoggingSubsystemParser.parseRootLoggerElement(reader, address, list);
                            continue block13;
                        }
                        case CONSOLE_HANDLER: {
                            LoggingSubsystemParser.parseConsoleHandlerElement(reader, address, list, handlerNames);
                            continue block13;
                        }
                        case FILE_HANDLER: {
                            LoggingSubsystemParser.parseFileHandlerElement(reader, address, list, handlerNames);
                            continue block13;
                        }
                        case CUSTOM_HANDLER: {
                            LoggingSubsystemParser.parseCustomHandlerElement(reader, address, list, handlerNames);
                            continue block13;
                        }
                        case PERIODIC_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, address, list, handlerNames);
                            continue block13;
                        }
                        case SIZE_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, address, list, handlerNames);
                            continue block13;
                        }
                        case ASYNC_HANDLER: {
                            LoggingSubsystemParser.parseAsyncHandlerElement(reader, address, list, handlerNames);
                            continue block13;
                        }
                    }
                    reader.handleAny(list);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CATEGORY: {
                    CommonAttributes.CATEGORY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block12;
                }
                case USE_PARENT_HANDLERS: {
                    CommonAttributes.USE_PARENT_HANDLERS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("logger", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: 
                case LOGGING_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    switch (element) {
                        case LEVEL: {
                            CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                            continue block13;
                        }
                        case HANDLERS: {
                            LoggingSubsystemParser.parseHandlersElement(node.get(CommonAttributes.HANDLERS.getName()), reader);
                            continue block13;
                        }
                        case FILTER: {
                            LoggingSubsystemParser.parseFilter(node, reader);
                            continue block13;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseAsyncHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    CommonAttributes.NAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("async-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block12;
                }
                case SUBHANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(node.get(CommonAttributes.SUBHANDLERS.getName()), reader);
                    continue block12;
                }
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(node, reader);
                    continue block12;
                }
                case FORMATTER: {
                    CommonAttributes.FORMATTER.parseAndSetParameter(LoggingSubsystemParser.parseFormatterElement(reader), node, (XMLStreamReader)reader);
                    continue block12;
                }
                case QUEUE_LENGTH: {
                    CommonAttributes.QUEUE_LENGTH.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block12;
                }
                case OVERFLOW_ACTION: {
                    CommonAttributes.OVERFLOW_ACTION.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value").toUpperCase(Locale.US), node, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseRootLoggerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("root-logger", "ROOT");
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: 
                case LOGGING_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    if (encountered.contains((Object)element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    encountered.add(element);
                    switch (element) {
                        case FILTER: {
                            LoggingSubsystemParser.parseFilter(node, reader);
                            continue block8;
                        }
                        case LEVEL: {
                            CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                            continue block8;
                        }
                        case HANDLERS: {
                            LoggingSubsystemParser.parseHandlersElement(node.get(CommonAttributes.HANDLERS.getName()), reader);
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseConsoleHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    CommonAttributes.NAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block11;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("console-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block12;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block12;
                }
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(node, reader);
                    continue block12;
                }
                case FORMATTER: {
                    CommonAttributes.FORMATTER.parseAndSetParameter(LoggingSubsystemParser.parseFormatterElement(reader), node, (XMLStreamReader)reader);
                    continue block12;
                }
                case TARGET: {
                    String target = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    if (!target.equals("System.out") && !target.equals("System.err")) {
                        throw new XMLStreamException(LoggingMessages.MESSAGES.invalidTargetName(EnumSet.allOf(Target.class)), reader.getLocation());
                    }
                    CommonAttributes.TARGET.parseAndSetParameter(target, node, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseFileHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    CommonAttributes.NAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(node, reader);
                    continue block13;
                }
                case FORMATTER: {
                    CommonAttributes.FORMATTER.parseAndSetParameter(LoggingSubsystemParser.parseFormatterElement(reader), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(node.get(CommonAttributes.FILE.getName()), reader);
                    continue block13;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        list.add(node);
    }

    static void parseCustomHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    CommonAttributes.NAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block12;
                }
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("custom-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(node, reader);
                    continue block13;
                }
                case FORMATTER: {
                    CommonAttributes.FORMATTER.parseAndSetParameter(LoggingSubsystemParser.parseFormatterElement(reader), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case PROPERTIES: {
                    LoggingSubsystemParser.parsePropertyElement(node, reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    CommonAttributes.NAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block13;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("periodic-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(node, reader);
                    continue block14;
                }
                case FORMATTER: {
                    CommonAttributes.FORMATTER.parseAndSetParameter(LoggingSubsystemParser.parseFormatterElement(reader), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(node.get(CommonAttributes.FILE.getName()), reader);
                    continue block14;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case SUFFIX: {
                    CommonAttributes.SUFFIX.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        list.add(node);
    }

    static void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    CommonAttributes.NAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    name = value;
                    continue block14;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address).add("size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(node, reader);
                    continue block15;
                }
                case FORMATTER: {
                    CommonAttributes.FORMATTER.parseAndSetParameter(LoggingSubsystemParser.parseFormatterElement(reader), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(node.get(CommonAttributes.FILE.getName()), reader);
                    continue block15;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case ROTATE_SIZE: {
                    CommonAttributes.ROTATE_SIZE.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case MAX_BACKUP_INDEX: {
                    CommonAttributes.MAX_BACKUP_INDEX.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    private static void parseFileElement(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    CommonAttributes.PATH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    CommonAttributes.RELATIVE_TO.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String parseFormatterElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String formatterSpec;
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        if (reader.nextTag() != 1) {
            throw new XMLStreamException(LoggingMessages.MESSAGES.missingRequiredNestedFilterElement(), reader.getLocation());
        }
        block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
            case LOGGING_1_0: 
            case LOGGING_1_1: {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case PATTERN_FORMATTER: {
                        formatterSpec = LoggingSubsystemParser.parsePatternFormatterElement(reader);
                        break block0;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        if (reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return formatterSpec;
    }

    private static String parsePatternFormatterElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String pattern = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return pattern;
    }

    private static void parsePropertyElement(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            int cnt = reader.getAttributeCount();
            String name = null;
            String value = null;
            block5: for (int i = 0; i < cnt; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case VALUE: {
                        value = attrValue;
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
            }
            node.get("properties").add(name, new ModelNode().set(value));
            if (reader.nextTag() == 2) continue;
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHandlersElement(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: 
                case LOGGING_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HANDLER: {
                            node.add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseFilter(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        LoggingSubsystemParser.parseFilterChildren(node.get(CommonAttributes.FILTER.getName()), reader);
    }

    private static void parseFilterChildren(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: 
                case LOGGING_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ACCEPT: {
                            CommonAttributes.ACCEPT.parseAndSetParameter(Boolean.TRUE.toString(), node, (XMLStreamReader)reader);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block15;
                        }
                        case ALL: {
                            LoggingSubsystemParser.parseFilterChildren(node.get(CommonAttributes.ALL.getName()), reader);
                            continue block15;
                        }
                        case ANY: {
                            LoggingSubsystemParser.parseFilterChildren(node.get(CommonAttributes.ANY.getName()), reader);
                            continue block15;
                        }
                        case CHANGE_LEVEL: {
                            CommonAttributes.CHANGE_LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"new-level"), node, (XMLStreamReader)reader);
                            continue block15;
                        }
                        case DENY: {
                            CommonAttributes.DENY.parseAndSetParameter(Boolean.TRUE.toString(), node, (XMLStreamReader)reader);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block15;
                        }
                        case LEVEL: {
                            CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                            continue block15;
                        }
                        case LEVEL_RANGE: {
                            ModelNode levelRange = node.get(CommonAttributes.LEVEL_RANGE.getName());
                            LoggingSubsystemParser.parseRequiredAttribute(CommonAttributes.MIN_LEVEL, reader, levelRange);
                            LoggingSubsystemParser.parseRequiredAttribute(CommonAttributes.MAX_LEVEL, reader, levelRange);
                            LoggingSubsystemParser.parseAttribute(CommonAttributes.MIN_INCLUSIVE, reader, levelRange);
                            LoggingSubsystemParser.parseAttribute(CommonAttributes.MAX_INCLUSIVE, reader, levelRange);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block15;
                        }
                        case MATCH: {
                            CommonAttributes.MATCH.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"pattern"), node, (XMLStreamReader)reader);
                            continue block15;
                        }
                        case NOT: {
                            LoggingSubsystemParser.parseFilterChildren(node.get(CommonAttributes.NOT.getName()), reader);
                            continue block15;
                        }
                        case REPLACE: {
                            ModelNode replace = node.get(CommonAttributes.REPLACE.getName());
                            LoggingSubsystemParser.parseRequiredAttribute(CommonAttributes.PATTERN, reader, replace);
                            LoggingSubsystemParser.parseRequiredAttribute(CommonAttributes.REPLACEMENT, reader, replace);
                            LoggingSubsystemParser.parseAttribute(CommonAttributes.REPLACE_ALL, reader, replace);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block15;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseRequiredAttribute(SimpleAttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(attribute.getName()));
        }
        attribute.parseAndSetParameter(value, node, (XMLStreamReader)reader);
    }

    private static void parseAttribute(SimpleAttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getName());
        if (value != null) {
            attribute.parseAndSetParameter(reader.getAttributeValue(null, attribute.getName()), node, (XMLStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode handler;
        String name;
        ModelNode handlers;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("async-handler")) {
            handlers = node.get("async-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeAsynchHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("console-handler")) {
            handlers = node.get("console-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeConsoleHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("file-handler")) {
            handlers = node.get("file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("custom-handler")) {
            handlers = node.get("custom-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeCustomHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("periodic-rotating-file-handler")) {
            handlers = node.get("periodic-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("size-rotating-file-handler")) {
            handlers = node.get("size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("logger")) {
            for (String name2 : node.get("logger").keys()) {
                this.writeLogger(writer, name2, node.get(new String[]{"logger", name2}));
            }
        }
        if (node.hasDefined("root-logger")) {
            this.writeRootLogger(writer, node.get(new String[]{"root-logger", "ROOT"}));
        }
        writer.writeEndElement();
    }

    private void writeConsoleHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CONSOLE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        if (CommonAttributes.TARGET.isMarshallable(node)) {
            writer.writeStartElement(Element.TARGET.getLocalName());
            this.writeAttribute(writer, Attribute.NAME, node.get(CommonAttributes.TARGET.getName()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        this.writeFile(writer, node);
        this.writeAppend(writer, node);
        writer.writeEndElement();
    }

    private void writeCustomHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CUSTOM_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
        CommonAttributes.CLASS.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.MODULE.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        writer.writeEndElement();
    }

    private void writePeriodicRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        this.writeFile(writer, node);
        if (CommonAttributes.SUFFIX.isMarshallable(node)) {
            writer.writeStartElement(Element.SUFFIX.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get(CommonAttributes.SUFFIX.getName()));
            writer.writeEndElement();
        }
        this.writeAppend(writer, node);
        writer.writeEndElement();
    }

    private void writeSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        this.writeFile(writer, node);
        if (CommonAttributes.ROTATE_SIZE.isMarshallable(node)) {
            writer.writeStartElement(Element.ROTATE_SIZE.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get(CommonAttributes.ROTATE_SIZE.getName()));
            writer.writeEndElement();
        }
        if (CommonAttributes.MAX_BACKUP_INDEX.isMarshallable(node)) {
            writer.writeStartElement(Element.MAX_BACKUP_INDEX.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get(CommonAttributes.MAX_BACKUP_INDEX.getName()));
            writer.writeEndElement();
        }
        this.writeAppend(writer, node);
        writer.writeEndElement();
    }

    private void writeAsynchHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.ASYNC_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
        this.writeLevel(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        if (CommonAttributes.QUEUE_LENGTH.isMarshallable(node)) {
            writer.writeStartElement(Element.QUEUE_LENGTH.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get(CommonAttributes.QUEUE_LENGTH.getName()));
            writer.writeEndElement();
        }
        if (CommonAttributes.OVERFLOW_ACTION.isMarshallable(node)) {
            writer.writeStartElement(Element.OVERFLOW_ACTION.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), node.get(CommonAttributes.OVERFLOW_ACTION.getName()).asString().toLowerCase(Locale.ENGLISH));
            writer.writeEndElement();
        }
        if (CommonAttributes.SUBHANDLERS.isMarshallable(node)) {
            ModelNode handlers = node.get(CommonAttributes.SUBHANDLERS.getName());
            this.writeHandlersContent(writer, Element.SUBHANDLERS, handlers);
        }
        writer.writeEndElement();
    }

    private void writeLogger(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.LOGGER.getLocalName());
        writer.writeAttribute(CommonAttributes.CATEGORY.getXmlName(), name);
        CommonAttributes.USE_PARENT_HANDLERS.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeLevel(writer, node);
        this.writeFilter(writer, node);
        this.writeHandlers(writer, node);
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ROOT_LOGGER.getLocalName());
        this.writeLevel(writer, node);
        this.writeFilter(writer, node);
        this.writeHandlers(writer, node);
        writer.writeEndElement();
    }

    private void writeLevel(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.LEVEL.isMarshallable(node)) {
            writer.writeStartElement(Element.LEVEL.getLocalName());
            this.writeAttribute(writer, Attribute.NAME, node.get(CommonAttributes.LEVEL.getName()));
            writer.writeEndElement();
        }
    }

    private void writeFilter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.FILTER.isMarshallable(node)) {
            ModelNode filter = node.get(CommonAttributes.FILTER.getName());
            writer.writeStartElement(CommonAttributes.FILTER.getXmlName());
            this.writeFilterChildren(writer, filter);
            writer.writeEndElement();
        }
    }

    private void writeFilterChildren(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.doMarshal(writer, (AttributeDefinition)CommonAttributes.ACCEPT, null, node);
        if (CommonAttributes.ALL.isMarshallable(node)) {
            writer.writeStartElement(CommonAttributes.ALL.getXmlName());
            this.writeFilterChildren(writer, node.get(CommonAttributes.ALL.getName()));
            writer.writeEndElement();
        }
        if (CommonAttributes.ANY.isMarshallable(node)) {
            writer.writeStartElement(CommonAttributes.ANY.getXmlName());
            this.writeFilterChildren(writer, node.get(CommonAttributes.ANY.getName()));
            writer.writeEndElement();
        }
        this.doMarshal(writer, (AttributeDefinition)CommonAttributes.CHANGE_LEVEL, (AttributeDefinition)CommonAttributes.NEW_LEVEL, node);
        this.doMarshal(writer, (AttributeDefinition)CommonAttributes.DENY, null, node);
        this.writeLevel(writer, node);
        this.doMarshal(writer, (AttributeDefinition)CommonAttributes.LEVEL_RANGE, node, new AttributeDefinition[]{CommonAttributes.MIN_LEVEL, CommonAttributes.MIN_INCLUSIVE, CommonAttributes.MAX_LEVEL, CommonAttributes.MAX_INCLUSIVE});
        this.doMarshal(writer, (AttributeDefinition)CommonAttributes.MATCH, (AttributeDefinition)CommonAttributes.PATTERN, node);
        if (CommonAttributes.NOT.isMarshallable(node)) {
            writer.writeStartElement(CommonAttributes.NOT.getXmlName());
            this.writeFilterChildren(writer, node.get(CommonAttributes.NOT.getName()));
            writer.writeEndElement();
        }
        this.doMarshal(writer, (AttributeDefinition)CommonAttributes.REPLACE, node, new AttributeDefinition[]{CommonAttributes.PATTERN, CommonAttributes.REPLACEMENT, CommonAttributes.REPLACE_ALL});
    }

    private void writeProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("properties")) {
            writer.writeStartElement(Element.PROPERTIES.getLocalName());
            List props = node.get("properties").asPropertyList();
            for (Property prop : props) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                this.writeAttribute(writer, Attribute.VALUE, prop.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeFormatter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.FORMATTER.isMarshallable(node)) {
            writer.writeStartElement(Element.FORMATTER.getLocalName());
            writer.writeStartElement(Element.PATTERN_FORMATTER.getLocalName());
            this.writeAttribute(writer, Attribute.PATTERN, node.get(CommonAttributes.FORMATTER.getName()));
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeFile(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.FILE.isMarshallable(node)) {
            writer.writeStartElement(Element.FILE.getLocalName());
            ModelNode file = node.get(CommonAttributes.FILE.getName());
            CommonAttributes.RELATIVE_TO.marshallAsAttribute(file, (XMLStreamWriter)writer);
            CommonAttributes.PATH.marshallAsAttribute(file, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeEncoding(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.ENCODING.isMarshallable(node)) {
            writer.writeStartElement(Element.ENCODING.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get(CommonAttributes.ENCODING.getName()));
            writer.writeEndElement();
        }
    }

    private void writeHandlers(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.HANDLERS.isMarshallable(node)) {
            ModelNode handlers = node.get(CommonAttributes.HANDLERS.getName());
            this.writeHandlersContent(writer, Element.HANDLERS, handlers);
        }
    }

    private void writeHandlersContent(XMLExtendedStreamWriter writer, Element element, ModelNode handlers) throws XMLStreamException {
        if (handlers.getType() == ModelType.LIST) {
            writer.writeStartElement(element.getLocalName());
            for (ModelNode handler : handlers.asList()) {
                if (!handler.isDefined()) continue;
                writer.writeStartElement(Element.HANDLER.getLocalName());
                this.writeAttribute(writer, Attribute.NAME, handler);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeAppend(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (CommonAttributes.APPEND.isMarshallable(node)) {
            writer.writeStartElement(Element.APPEND.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get(CommonAttributes.APPEND.getName()));
            writer.writeEndElement();
        }
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    private void doMarshal(XMLExtendedStreamWriter writer, AttributeDefinition element, AttributeDefinition attribute, ModelNode node) throws XMLStreamException {
        if (element.isMarshallable(node)) {
            if (attribute == null) {
                writer.writeEmptyElement(element.getXmlName());
            } else {
                writer.writeStartElement(element.getXmlName());
                writer.writeAttribute(attribute.getXmlName(), node.get(element.getXmlName()).asString());
                writer.writeEndElement();
            }
        }
    }

    private void doMarshal(XMLExtendedStreamWriter writer, AttributeDefinition element, ModelNode node, AttributeDefinition ... attributes) throws XMLStreamException {
        if (element.isMarshallable(node)) {
            writer.writeStartElement(element.getXmlName());
            ModelNode elementNode = node.get(element.getName());
            for (AttributeDefinition attribute : attributes) {
                if (!attribute.isMarshallable(elementNode)) continue;
                writer.writeAttribute(attribute.getXmlName(), elementNode.get(attribute.getName()).asString());
            }
            writer.writeEndElement();
        }
    }
}

