/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.AbstractOperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Filters;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class LoggingOperationTransformer
extends AbstractOperationTransformer {
    static final LoggingOperationTransformer INSTANCE = new LoggingOperationTransformer();

    LoggingOperationTransformer() {
    }

    protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
        String key = address.getLastElement().getKey();
        String name = address.getLastElement().getValue();
        String operationName = operation.get("operation").asString();
        ModelNode originalOperation = operation.clone();
        if (operationName.equals("add-handler")) {
            if (key.equals("root-logger")) {
                operation.get("operation").set("root-logger-assign-handler");
            } else if (key.equals("logger")) {
                operation.get("operation").set("assign-handler");
            } else if (key.equals("async-handler")) {
                operation.get("operation").set("assign-subhandler");
            }
        } else if (operationName.equals("remove-handler")) {
            if (key.equals("root-logger")) {
                operation.get("operation").set("root-logger-unassign-handler");
            } else if (key.equals("logger")) {
                operation.get("operation").set("unassign-handler");
            } else if (key.equals("async-handler")) {
                operation.get("operation").set("unassign-subhandler");
            }
        } else if (operationName.equals("write-attribute")) {
            String attributeName = operation.get("name").asString();
            if (operation.get("value").getType() != ModelType.EXPRESSION) {
                if (attributeName.equals(CommonAttributes.FORMATTER.getName())) {
                    String currentPattern = operation.get("value").asString();
                    operation.get("value").set(Logging.fixFormatPattern(currentPattern));
                } else if (attributeName.equals(CommonAttributes.FILTER_SPEC.getName())) {
                    operation.get("name").set(CommonAttributes.FILTER.getName());
                    String filterExpression = operation.get("value").asString();
                    operation.get("value").set(Filters.filterSpecToFilter(filterExpression));
                } else if (attributeName.equals(CommonAttributes.ENABLED.getName())) {
                    boolean enabled = operation.get("value").asBoolean();
                    if (enabled) {
                        operation.get("operation").set(AbstractHandlerDefinition.ENABLE_HANDLER.getName());
                    } else {
                        operation.get("operation").set(AbstractHandlerDefinition.DISABLE_HANDLER.getName());
                    }
                    operation.remove("name");
                    operation.remove("value");
                }
            }
        } else if (operationName.equals("add")) {
            if ("logger".equals(key)) {
                operation.get(LoggerResourceDefinition.CATEGORY.getName()).set(name);
            } else if (!"root-logger".equals(key)) {
                operation.get(CommonAttributes.NAME.getName()).set(name);
            }
        } else if (operationName.equals("set-root-logger")) {
            operation.remove(CommonAttributes.NAME.getName());
        }
        if (operation.hasDefined(CommonAttributes.FORMATTER.getName()) && operation.get(CommonAttributes.FORMATTER.getName()).getType() != ModelType.EXPRESSION) {
            String currentPattern = operation.get(CommonAttributes.FORMATTER.getName()).asString();
            operation.get(CommonAttributes.FORMATTER.getName()).set(Logging.fixFormatPattern(currentPattern));
        }
        if (operation.hasDefined(CommonAttributes.FILTER_SPEC.getName()) && operation.get(CommonAttributes.FILTER_SPEC.getName()).getType() != ModelType.EXPRESSION) {
            String filterExpression = operation.get(CommonAttributes.FILTER_SPEC.getName()).asString();
            operation.get(CommonAttributes.FILTER.getName()).set(Filters.filterSpecToFilter(filterExpression));
        }
        operation.remove(CommonAttributes.FILTER_SPEC.getName());
        operation.remove(CommonAttributes.ENABLED.getName());
        LoggingLogger.ROOT_LOGGER.tracef("Changed operation from: %s%nto: %s", originalOperation, operation);
        return operation;
    }
}

