/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionServer;
import org.jboss.dmr.ModelNode;

public class Util {
    static void fillFrom(ModelNode operation, MailSessionConfig sessionConfig) {
        operation.get("jndi-name").set(sessionConfig.getJndiName());
        operation.get("debug").set(sessionConfig.isDebug());
        if (sessionConfig.getSmtpServer() != null) {
            Util.addServerConfig(operation, sessionConfig.getSmtpServer(), "smtp-server");
        }
        if (sessionConfig.getPop3Server() != null) {
            Util.addServerConfig(operation, sessionConfig.getPop3Server(), "pop3-server");
        }
        if (sessionConfig.getImapServer() != null) {
            Util.addServerConfig(operation, sessionConfig.getImapServer(), "imap-server");
        }
    }

    private static void addServerConfig(ModelNode operation, MailSessionServer server, String name) {
        operation.get(name).get("outbound-socket-binding-ref").set(server.getOutgoingSocketBinding());
        Util.addCredentials(operation.get(name), server.getCredentials());
    }

    private static void addCredentials(ModelNode operation, Credentials credentials) {
        if (credentials != null) {
            operation.get("credentials").get("name").set(credentials.getUsername());
            operation.get("credentials").get("password").set(credentials.getPassword());
        }
    }

    private static MailSessionServer readServerConfig(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        String socket = model.require("outbound-socket-binding-ref").asString();
        Credentials credentials = Util.readCredentials(operationContext, model);
        return new MailSessionServer(socket, credentials);
    }

    private static Credentials readCredentials(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        if (model.has("credentials")) {
            String un = model.get("credentials").get("name").asString();
            String pw = operationContext.resolveExpressions(model.get(new String[]{"credentials", "password"})).asString();
            return new Credentials(un, pw);
        }
        return null;
    }

    static MailSessionConfig from(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        MailSessionConfig cfg = new MailSessionConfig();
        cfg.setJndiName(model.require("jndi-name").asString());
        cfg.setDebug(model.get("debug").asBoolean(false));
        if (model.hasDefined("smtp-server")) {
            cfg.setSmtpServer(Util.readServerConfig(operationContext, model.get("smtp-server")));
        }
        if (model.hasDefined("pop3-server")) {
            cfg.setPop3Server(Util.readServerConfig(operationContext, model.get("pop3-server")));
        }
        if (model.hasDefined("imap-server")) {
            cfg.setPop3Server(Util.readServerConfig(operationContext, model.get("imap-server")));
        }
        return cfg;
    }

    public static String getJndiName(ModelNode modelNode) {
        String rawJndiName = modelNode.require("jndi-name").asString();
        String jndiName = !rawJndiName.startsWith("java:") ? "java:jboss/mail/" + rawJndiName : rawJndiName;
        return jndiName;
    }
}

