/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.container;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.as.deployment.managedbean.container.InvocationContext;
import org.jboss.as.deployment.managedbean.container.ResourceInjection;

public class ManagedBeanInterceptor<T> {
    private final Class<T> interceptorType;
    private final Method aroundInvokeMethod;
    private final List<ResourceInjection<?>> resourceInjections;

    public ManagedBeanInterceptor(Class<T> interceptorType, Method aroundInvokeMethod, List<ResourceInjection<?>> resourceInjections) {
        this.interceptorType = interceptorType;
        this.aroundInvokeMethod = aroundInvokeMethod;
        this.resourceInjections = resourceInjections;
    }

    AroundInvokeInterceptor<T> createInstance() throws IllegalAccessException, InstantiationException {
        T interceptor = this.interceptorType.newInstance();
        for (ResourceInjection<?> resourceInjection : this.resourceInjections) {
            resourceInjection.inject(interceptor);
        }
        return new AroundInvokeInterceptor<T>(interceptor, this.aroundInvokeMethod);
    }

    public String toString() {
        return "ManagedBeanInterceptor{interceptorType=" + this.interceptorType + '}';
    }

    static class AroundInvokeInterceptor<T> {
        private T target;
        private Method aroundInvokeMethod;

        AroundInvokeInterceptor(T target, Method aroundInvokeMethod) {
            this.target = target;
            this.aroundInvokeMethod = aroundInvokeMethod;
        }

        Object intercept(InvocationContext<?> invocationContext) throws Exception {
            return this.aroundInvokeMethod.invoke(this.target, invocationContext);
        }
    }
}

