/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.container;

import org.jboss.as.deployment.managedbean.container.ManagedBeanContainer;
import org.jboss.as.deployment.managedbean.container.ManagedBeanRegistry;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ManagedBeanService<T>
implements Service<ManagedBeanContainer<T>> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"managed", "bean"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.managedbean");
    private final ManagedBeanContainer<T> container;

    public ManagedBeanService(ManagedBeanContainer<T> container) {
        this.container = container;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            ServiceName serviceName = context.getController().getName();
            log.infof("Starting managed bean %s", (Object)serviceName);
            ManagedBeanRegistry.register(serviceName.toString(), this.container);
        }
        catch (ManagedBeanRegistry.DuplicateMangedBeanException e) {
            throw new StartException("Failed to register with the managed bean registry");
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceName serviceName = context.getController().getName();
        log.infof("Stopping managed bean %s", (Object)serviceName);
        ManagedBeanRegistry.unregister(context.getController().getName().toString(), this.container);
    }

    public ManagedBeanContainer<T> getValue() throws IllegalStateException {
        return this.container;
    }
}

