/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mc;

import java.io.Closeable;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.mc.ParseResult;
import org.jboss.as.mc.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.as.mc.descriptor.KernelDeploymentXmlDescriptorParser;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class KernelDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    private final XMLMapper xmlMapper = XMLMapper.Factory.create();
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public KernelDeploymentParsingProcessor() {
        this.xmlMapper.registerRootElement(new QName("urn:jboss:mc:7.0", "deployment"), (XMLElementReader)new KernelDeploymentXmlDescriptorParser());
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block11: {
            VirtualFile deploymentRoot = ((ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            String deploymentRootName = deploymentRoot.getLowerCaseName();
            VirtualFile beansXmlFile = null;
            if (deploymentRootName.endsWith(".jar")) {
                beansXmlFile = deploymentRoot.getChild("META-INF/jboss-beans.xml");
            } else if (deploymentRootName.endsWith("jboss-beans.xml")) {
                beansXmlFile = deploymentRoot;
            }
            if (beansXmlFile == null || !beansXmlFile.exists()) {
                return;
            }
            InputStream xmlStream = null;
            try {
                xmlStream = beansXmlFile.openStream();
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(xmlStream);
                ParseResult result = new ParseResult();
                this.xmlMapper.parseDocument(result, reader);
                KernelDeploymentXmlDescriptor xmlDescriptor = (KernelDeploymentXmlDescriptor)result.getResult();
                if (xmlDescriptor != null) {
                    phaseContext.getDeploymentUnit().putAttachment(KernelDeploymentXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block11;
                }
                throw new DeploymentUnitProcessingException("Failed to parse MC beans xml [" + beansXmlFile + "]");
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse MC beans xml [" + beansXmlFile + "]", (Throwable)e);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

