/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.SecurityActions;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSService
implements Service<JMSServerManager> {
    private final InjectedValue<HornetQServer> hornetQServer = new InjectedValue();
    private final InjectedValue<NamingStore> namingStoreInjector = new InjectedValue();
    private JMSServerManager jmsServer;

    public static void addService(ServiceTarget target) {
        JMSService service = new JMSService();
        target.addService(JMSServices.JMS_MANAGER, (Service)service).addDependency(MessagingServices.JBOSS_MESSAGING, HornetQServer.class, service.getHornetQServer()).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, service.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    protected JMSService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        try {
            JMSServerManagerImpl jmsServer = new JMSServerManagerImpl((HornetQServer)this.hornetQServer.getValue());
            NamingStore namingStore = (NamingStore)this.namingStoreInjector.getOptionalValue();
            if (namingStore != null) {
                jmsServer.setContext((Context)namingStore.lookup((Name)new CompositeName()));
            }
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                SecurityActions.setContextClassLoader(loader);
                jmsServer.start();
            }
            finally {
                SecurityActions.setContextClassLoader(null);
            }
            this.jmsServer = jmsServer;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsServer = this.jmsServer;
        this.jmsServer = null;
        try {
            jmsServer.stop();
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").error((Object)"exception while stopping jms server", (Throwable)e);
        }
    }

    public synchronized JMSServerManager getValue() throws IllegalStateException {
        JMSServerManager jmsServer = this.jmsServer;
        if (jmsServer == null) {
            throw new IllegalStateException();
        }
        return jmsServer;
    }

    InjectedValue<HornetQServer> getHornetQServer() {
        return this.hornetQServer;
    }

    InjectedValue<NamingStore> getNamingStoreInjector() {
        return this.namingStoreInjector;
    }
}

