/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.HashSet;
import org.hornetq.api.core.Pair;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.jms.ConnectionFactoryService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class ConnectionFactoryAdd
implements ModelAddOperationHandler {
    static final ConnectionFactoryAdd INSTANCE = new ConnectionFactoryAdd();
    private static final String[] NO_BINDINGS = new String[0];

    ConnectionFactoryAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        ModelNode subModel = context.getSubModel();
        for (String attribute : JMSServices.CF_ATTRIBUTES) {
            if (!operation.hasDefined(attribute)) continue;
            subModel.get(attribute).set(operation.get(attribute));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ConnectionFactoryConfiguration configuration = ConnectionFactoryAdd.createConfiguration(name, operation);
                    ConnectionFactoryService service = new ConnectionFactoryService(configuration);
                    ServiceName serviceName = JMSServices.JMS_CF_BASE.append(new String[]{name});
                    context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    static ConnectionFactoryConfiguration createConfiguration(String name, ModelNode operation) {
        ConnectionFactoryConfigurationImpl config = new ConnectionFactoryConfigurationImpl(name, ConnectionFactoryAdd.jndiBindings(operation));
        config.setAutoGroup(operation.get("auto-group").asBoolean(false));
        config.setBlockOnAcknowledge(operation.get("block-on-acknowledge").asBoolean(false));
        config.setBlockOnDurableSend(operation.get("block-on-durable-send").asBoolean(true));
        config.setBlockOnNonDurableSend(operation.get("block-on-non-durable-send").asBoolean(false));
        config.setCacheLargeMessagesClient(operation.get("cache-large-message-client").asBoolean(false));
        config.setCallTimeout(operation.get("call-timeout").asLong(30000L));
        config.setClientFailureCheckPeriod((long)operation.get("client-failure-check-period").asInt(30000));
        if (operation.hasDefined("client-id")) {
            config.setClientID(operation.get("client-id").asString());
        }
        config.setConfirmationWindowSize(operation.get("confirmation-window-size").asInt(-1));
        config.setConnectionTTL(operation.get("connection-ttl").asLong(60000L));
        if (operation.hasDefined("connector")) {
            ModelNode connectorRefs = operation.get("connector");
            ArrayList<Pair> connectorNames = new ArrayList<Pair>();
            for (String connectorName : operation.get("connector").keys()) {
                ModelNode connectorRef = connectorRefs.get(connectorName);
                String backup = connectorRef.hasDefined("backup-connector-name") ? connectorRef.get("backup-connector-name").asString() : null;
                connectorNames.add(new Pair((Object)connectorName, (Object)backup));
            }
            config.setConnectorNames(connectorNames);
        }
        config.setConsumerMaxRate(operation.get("consumer-max-rate").asInt(-1));
        config.setConsumerWindowSize(operation.get("consumer-window-size").asInt(0x100000));
        if (operation.hasDefined("discovery-group-name")) {
            config.setDiscoveryGroupName(operation.get("discovery-group-name").asString());
        }
        config.setDupsOKBatchSize(operation.get("dups-ok-batch-size").asInt(0x100000));
        config.setFailoverOnInitialConnection(operation.get("failover-on-initial-connection").asBoolean(false));
        config.setFailoverOnServerShutdown(operation.get("failover-on-server-shutdown").asBoolean(false));
        if (operation.hasDefined("group-id")) {
            config.setGroupID(operation.get("group-id").asString());
        }
        config.setInitialWaitTimeout(operation.get("discovery-initial-wait-timeout").asLong(10000L));
        if (operation.hasDefined("connection-load-balancing-policy-class-name")) {
            config.setLoadBalancingPolicyClassName(operation.get("connection-load-balancing-policy-class-name").asString());
        }
        config.setMaxRetryInterval(operation.get("max-retry-interval").asLong(2000L));
        config.setMinLargeMessageSize(operation.get("min-large-message-size").asInt(102400));
        config.setPreAcknowledge(operation.get("pre-acknowledge").asBoolean(false));
        config.setProducerMaxRate(operation.get("producer-max-rate").asInt(-1));
        config.setProducerWindowSize(operation.get("producer-window-size").asInt(65536));
        config.setReconnectAttempts(operation.get("reconnect-attempts").asInt(0));
        config.setRetryInterval(operation.get("retry-interval").asLong(2000L));
        config.setRetryIntervalMultiplier(operation.get("retry-interval-multiplier").asDouble(1.0));
        config.setScheduledThreadPoolMaxSize(operation.get("scheduled-thread-pool-max-size").asInt(5));
        config.setThreadPoolMaxSize(operation.get("thread-pool-max-size").asInt(-1));
        config.setTransactionBatchSize(operation.get("transaction-batch-size").asInt(0x100000));
        config.setUseGlobalPools(operation.get("use-global-pools").asBoolean(true));
        return config;
    }

    static String[] jndiBindings(ModelNode node) {
        if (node.hasDefined("entries")) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get("entries").asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }

    static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (String attribute : JMSServices.CF_ATTRIBUTES) {
            if (!subModel.hasDefined(attribute)) continue;
            operation.get(attribute).set(subModel.get(attribute));
        }
        return operation;
    }
}

