/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.deployment.MessagingAttachments;
import org.jboss.as.messaging.deployment.MessagingDeploymentParser_1_0;
import org.jboss.as.messaging.deployment.Namespace;
import org.jboss.as.messaging.deployment.ParseResult;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class MessagingXmlParsingDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final String[] LOCATIONS = new String[]{"WEB-INF", "META-INF"};
    private static final QName ROOT_1_0 = new QName(Namespace.MESSAGING_DEPLOYMENT_1_0.getUriString(), "messaging-deployment");
    private static final QName ROOT_NO_NAMESPACE = new QName("messaging-deployment");
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public MessagingXmlParsingDeploymentUnitProcessor() {
        this.mapper.registerRootElement(ROOT_1_0, (XMLElementReader)MessagingDeploymentParser_1_0.INSTANCE);
        this.mapper.registerRootElement(ROOT_NO_NAMESPACE, (XMLElementReader)MessagingDeploymentParser_1_0.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Set<VirtualFile> files = this.messageDestinations(deploymentUnit);
        for (VirtualFile file : files) {
            FileInputStream xmlStream = null;
            try {
                File f = file.getPhysicalFile();
                xmlStream = new FileInputStream(f);
                try {
                    XMLInputFactory inputFactory = INPUT_FACTORY;
                    this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
                    this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
                    XMLStreamReader streamReader = inputFactory.createXMLStreamReader(xmlStream);
                    ParseResult result = new ParseResult();
                    try {
                        this.mapper.parseDocument((Object)result, streamReader);
                        deploymentUnit.addToAttachmentList(MessagingAttachments.PARSE_RESULT, (Object)result);
                    }
                    finally {
                        MessagingXmlParsingDeploymentUnitProcessor.safeClose(streamReader, f.getAbsolutePath());
                    }
                }
                catch (XMLStreamException e) {
                    throw MessagingMessages.MESSAGES.couldNotParseDeployment(f.getPath(), e);
                }
            }
            catch (Exception e) {
                try {
                    throw new DeploymentUnitProcessingException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    VFSUtils.safeClose(xmlStream);
                    throw throwable;
                }
            }
            VFSUtils.safeClose((Closeable)xmlStream);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private Set<VirtualFile> messageDestinations(DeploymentUnit deploymentUnit) {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return Collections.emptySet();
        }
        String deploymentRootName = deploymentRoot.getLowerCaseName();
        if (deploymentRootName.endsWith("-jms.xml")) {
            return Collections.singleton(deploymentRoot);
        }
        HashSet<VirtualFile> ret = new HashSet<VirtualFile>();
        for (String location : LOCATIONS) {
            VirtualFile loc = deploymentRoot.getChild(location);
            if (!loc.exists()) continue;
            for (VirtualFile file : loc.getChildren()) {
                if (!file.getName().endsWith("-jms.xml")) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    private static void safeClose(XMLStreamReader closeable, String file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (XMLStreamException e) {
                MessagingLogger.ROOT_LOGGER.couldNotCloseFile(file, e);
            }
        }
    }
}

