/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.concurrent.Executor;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSQueueService
implements Service<Void> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<Executor> executorInjector = new InjectedValue();
    private final String queueName;
    private final String selectorString;
    private final boolean durable;
    private final String[] jndi;

    public JMSQueueService(String queueName, String selectorString, boolean durable, String[] jndi) {
        this.queueName = queueName;
        this.selectorString = selectorString;
        this.durable = durable;
        this.jndi = jndi;
    }

    public synchronized void start(final StartContext context) throws StartException {
        context.asynchronous();
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        ((Executor)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createQueue(false, JMSQueueService.this.queueName, JMSQueueService.this.selectorString, JMSQueueService.this.durable, JMSQueueService.this.jndi);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingMessages.MESSAGES.failedToCreate(e, "queue"));
                }
            }
        });
    }

    public synchronized void stop(final StopContext context) {
        context.asynchronous();
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        ((Executor)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.removeQueueFromJNDI(JMSQueueService.this.queueName);
                }
                catch (Throwable e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "queue", JMSQueueService.this.queueName);
                }
                context.complete();
            }
        });
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }

    public Injector<Executor> getExecutorInjector() {
        return this.executorInjector;
    }
}

