/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.hornetq.api.core.management.ClusterConnectionControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.AbstractHornetQComponentControlHandler;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ClusterConnectionControlHandler
extends AbstractHornetQComponentControlHandler<ClusterConnectionControl> {
    public static final ClusterConnectionControlHandler INSTANCE = new ClusterConnectionControlHandler();
    @Deprecated
    public static final String GET_STATIC_CONNECTORS_AS_JSON = "get-static-connectors-as-json";
    public static final String GET_NODES = "get-nodes";

    private ClusterConnectionControlHandler() {
    }

    @Override
    public void register(ManagementResourceRegistration registry) {
        super.register(registry);
        registry.registerReadOnlyAttribute("node-id", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        registry.registerReadOnlyAttribute("topology", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        EnumSet<OperationEntry.Flag> flags = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
        registry.registerOperationHandler(GET_STATIC_CONNECTORS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, ClusterConnectionControlHandler.GET_STATIC_CONNECTORS_AS_JSON, "cluster-connection", ModelType.STRING, false);
            }
        }, flags);
        registry.registerOperationHandler(GET_NODES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getGetNodes(locale);
            }
        }, flags);
    }

    @Override
    protected ClusterConnectionControl getHornetQComponentControl(HornetQServer hqServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (ClusterConnectionControl)ClusterConnectionControl.class.cast(hqServer.getManagementService().getResource("core.clusterconnection." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "cluster-connection";
    }

    @Override
    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("node-id".equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            context.getResult().set(control.getNodeID());
        } else if ("topology".equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            context.getResult().set(control.getTopology());
        } else {
            this.unsupportedAttribute(attributeName);
        }
    }

    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if (GET_STATIC_CONNECTORS_AS_JSON.equals(operationName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            try {
                context.getResult().set(control.getStaticConnectorsAsJSON());
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else if (GET_NODES.equals(operationName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            try {
                Map nodes = control.getNodes();
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : nodes.entrySet()) {
                    result.get((String)entry.getKey()).set((String)entry.getValue());
                }
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

