/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.Collections;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.deployment.JmsDestination;
import org.jboss.as.messaging.deployment.Namespace;
import org.jboss.as.messaging.deployment.ParseResult;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class MessagingDeploymentParser_1_0
implements XMLStreamConstants,
XMLElementReader<ParseResult> {
    private final PropertyReplacer propertyReplacer;
    private static final EnumSet<Element> SIMPLE_ROOT_RESOURCE_ELEMENTS = EnumSet.noneOf(Element.class);

    MessagingDeploymentParser_1_0(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
        switch (schemaVer) {
            case MESSAGING_DEPLOYMENT_1_0: {
                this.processHornetQServer(reader, result);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void processHornetQServer(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HORNETQ_SERVER: {
                    this.processHornetQ(reader, result);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processHornetQ(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        String hqServerName = null;
        int count = reader.getAttributeCount();
        if (count > 0) {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
            hqServerName = this.propertyReplacer.replaceProperties(reader.getAttributeValue(0).trim());
        }
        if (hqServerName == null || hqServerName.length() == 0) {
            hqServerName = "default";
        }
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JMS_DESTINATIONS: {
                    this.processJmsDestinations(reader, result, hqServerName);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processJmsDestinations(XMLExtendedStreamReader reader, ParseResult result, String hqServerName) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JMS_QUEUE: {
                    this.processJMSQueue(reader, hqServerName, result);
                    continue block4;
                }
                case JMS_TOPIC: {
                    this.processJMSTopic(reader, hqServerName, result);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processJMSTopic(XMLExtendedStreamReader reader, String hqServer, ParseResult result) throws XMLStreamException {
        String name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(0));
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode topic = new ModelNode();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = this.propertyReplacer.replaceProperties(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    CommonAttributes.ENTRIES.parseAndAddParameterElement(entry, topic, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.getTopics().add(new JmsDestination(topic, hqServer, name));
    }

    private void processJMSQueue(XMLExtendedStreamReader reader, String hqServer, ParseResult result) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(0));
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode queue = new ModelNode();
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = this.propertyReplacer.replaceProperties(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    CommonAttributes.ENTRIES.parseAndAddParameterElement(entry, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case SELECTOR: {
                    if (queue.has(CommonAttributes.SELECTOR.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SELECTOR.getLocalName());
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"string");
                    String selector = this.propertyReplacer.replaceProperties(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string"));
                    CommonAttributes.SELECTOR.parseAndSetParameter(selector, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    if (queue.has(CommonAttributes.DURABLE.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.DURABLE.getLocalName());
                    }
                    CommonAttributes.DURABLE.parseAndSetParameter(this.propertyReplacer.replaceProperties(reader.getElementText()), queue, (XMLStreamReader)reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.getQueues().add(new JmsDestination(queue, hqServer, name));
    }

    static {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            SIMPLE_ROOT_RESOURCE_ELEMENTS.add(Element.forName(attr.getXmlName()));
        }
    }
}

