/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSTopicControlHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSTopicControlHandler INSTANCE = new JMSTopicControlHandler();
    public static final String LIST_ALL_SUBSCRIPTIONS = "list-all-subscriptions";
    public static final String LIST_ALL_SUBSCRIPTIONS_AS_JSON = "list-all-subscriptions-as-json";
    public static final String LIST_DURABLE_SUBSCRIPTIONS = "list-durable-subscriptions";
    public static final String LIST_DURABLE_SUBSCRIPTIONS_AS_JSON = "list-durable-subscriptions-as-json";
    public static final String LIST_NON_DURABLE_SUBSCRIPTIONS = "list-non-durable-subscriptions";
    public static final String LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON = "list-non-durable-subscriptions-as-json";
    public static final String LIST_MESSAGES_FOR_SUBSCRIPTION = "list-messages-for-subscription";
    public static final String LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON = "list-messages-for-subscription-as-json";
    public static final String COUNT_MESSAGES_FOR_SUBSCRIPTION = "count-messages-for-subscription";
    public static final String SUBSCRIPTION_NAME = "subscription-name";
    public static final String DROP_DURABLE_SUBSCRIPTION = "drop-durable-subscription";
    public static final String DROP_ALL_SUBSCRIPTIONS = "drop-all-subscriptions";
    public static final String REMOVE_MESSAGES = "remove-messages";
    private static final String TOPIC = "jms-topic";
    private final ParametersValidator listMessagesForSubscriptionValidator = new ParametersValidator();
    private final ParametersValidator countMessagesForSubscriptionValidator = new ParametersValidator();
    private final ParametersValidator dropDurableSubscriptionValidator = new ParametersValidator();
    private final ParametersValidator removeMessagesValidator = new ParametersValidator();

    private JMSTopicControlHandler() {
        this.listMessagesForSubscriptionValidator.registerValidator(CommonAttributes.QUEUE_NAME.getName(), (ParameterValidator)new StringLengthValidator(1));
        this.countMessagesForSubscriptionValidator.registerValidator(CommonAttributes.CLIENT_ID.getName(), (ParameterValidator)new StringLengthValidator(1));
        this.countMessagesForSubscriptionValidator.registerValidator(SUBSCRIPTION_NAME, (ParameterValidator)new StringLengthValidator(1));
        this.countMessagesForSubscriptionValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, false));
        this.dropDurableSubscriptionValidator.registerValidator(CommonAttributes.CLIENT_ID.getName(), (ParameterValidator)new StringLengthValidator(1));
        this.dropDurableSubscriptionValidator.registerValidator(SUBSCRIPTION_NAME, (ParameterValidator)new StringLengthValidator(1));
        this.removeMessagesValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, false));
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
        EnumSet<OperationEntry.Flag> runtimeOnly = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        registry.registerOperationHandler(LIST_ALL_SUBSCRIPTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListSubscriptionsOperation(locale, JMSTopicControlHandler.LIST_ALL_SUBSCRIPTIONS);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_ALL_SUBSCRIPTIONS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSTopicControlHandler.LIST_ALL_SUBSCRIPTIONS_AS_JSON, JMSTopicControlHandler.TOPIC, ModelType.STRING, false);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_DURABLE_SUBSCRIPTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListSubscriptionsOperation(locale, JMSTopicControlHandler.LIST_DURABLE_SUBSCRIPTIONS);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_DURABLE_SUBSCRIPTIONS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSTopicControlHandler.LIST_DURABLE_SUBSCRIPTIONS_AS_JSON, JMSTopicControlHandler.TOPIC, ModelType.STRING, false);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_NON_DURABLE_SUBSCRIPTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListSubscriptionsOperation(locale, JMSTopicControlHandler.LIST_NON_DURABLE_SUBSCRIPTIONS);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSTopicControlHandler.LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON, JMSTopicControlHandler.TOPIC, ModelType.STRING, false);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_MESSAGES_FOR_SUBSCRIPTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListMessagesForSubscription(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListMessagesForSubscriptionAsJSON(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(COUNT_MESSAGES_FOR_SUBSCRIPTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getCountMessagesForSubscription(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(DROP_DURABLE_SUBSCRIPTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDropDurableSubscription(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(DROP_ALL_SUBSCRIPTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, JMSTopicControlHandler.DROP_ALL_SUBSCRIPTIONS, JMSTopicControlHandler.TOPIC);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(REMOVE_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getRemoveMessages(locale);
            }
        }, runtimeOnly);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block16: {
            ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
            String operationName = operation.require("operation").asString();
            String topicName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
            HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            TopicControl control = (TopicControl)TopicControl.class.cast(hqServer.getManagementService().getResource("jms.topic." + topicName));
            if (control == null) {
                ManagementUtil.rollbackOperationWithNoHandler(context, operation);
                return;
            }
            try {
                if (LIST_ALL_SUBSCRIPTIONS.equals(operationName)) {
                    String json = control.listAllSubscriptionsAsJSON();
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block16;
                }
                if (LIST_ALL_SUBSCRIPTIONS_AS_JSON.equals(operationName)) {
                    context.getResult().set(control.listAllSubscriptionsAsJSON());
                    break block16;
                }
                if (LIST_DURABLE_SUBSCRIPTIONS.equals(operationName)) {
                    String json = control.listDurableSubscriptionsAsJSON();
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block16;
                }
                if (LIST_DURABLE_SUBSCRIPTIONS_AS_JSON.equals(operationName)) {
                    context.getResult().set(control.listDurableSubscriptionsAsJSON());
                    break block16;
                }
                if (LIST_NON_DURABLE_SUBSCRIPTIONS.equals(operationName)) {
                    String json = control.listNonDurableSubscriptionsAsJSON();
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block16;
                }
                if (LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON.equals(operationName)) {
                    context.getResult().set(control.listNonDurableSubscriptionsAsJSON());
                    break block16;
                }
                if (LIST_MESSAGES_FOR_SUBSCRIPTION.equals(operationName)) {
                    this.listMessagesForSubscriptionValidator.validate(operation);
                    String queueName = operation.require(CommonAttributes.QUEUE_NAME.getName()).asString();
                    String json = control.listMessagesForSubscriptionAsJSON(queueName);
                    context.getResult().set(ModelNode.fromJSONString((String)json));
                    break block16;
                }
                if (LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON.equals(operationName)) {
                    String queueName = operation.require(CommonAttributes.QUEUE_NAME.getName()).asString();
                    context.getResult().set(control.listMessagesForSubscriptionAsJSON(queueName));
                    break block16;
                }
                if (COUNT_MESSAGES_FOR_SUBSCRIPTION.equals(operationName)) {
                    this.countMessagesForSubscriptionValidator.validate(operation);
                    String clientId = operation.require(CommonAttributes.CLIENT_ID.getName()).asString();
                    String subscriptionName = operation.require(SUBSCRIPTION_NAME).asString();
                    String filter = operation.hasDefined(CommonAttributes.FILTER.getName()) ? operation.get(CommonAttributes.FILTER.getName()).asString() : null;
                    context.getResult().set(control.countMessagesForSubscription(clientId, subscriptionName, filter));
                    break block16;
                }
                if (DROP_DURABLE_SUBSCRIPTION.equals(operationName)) {
                    this.dropDurableSubscriptionValidator.validate(operation);
                    String clientId = operation.require(CommonAttributes.CLIENT_ID.getName()).asString();
                    String subscriptionName = operation.require(SUBSCRIPTION_NAME).asString();
                    control.dropDurableSubscription(clientId, subscriptionName);
                    context.getResult();
                    break block16;
                }
                if (DROP_ALL_SUBSCRIPTIONS.equals(operationName)) {
                    control.dropAllSubscriptions();
                    context.getResult();
                    break block16;
                }
                if (REMOVE_MESSAGES.equals(operationName)) {
                    this.removeMessagesValidator.validate(operation);
                    String filter = operation.hasDefined(CommonAttributes.FILTER.getName()) ? operation.get(CommonAttributes.FILTER.getName()).asString() : null;
                    context.getResult().set(control.removeMessages(filter));
                    break block16;
                }
                throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        }
        context.completeStep();
    }
}

