/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigProperties;
import org.jboss.as.messaging.jms.PooledConnectionFactoryService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class PooledConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final PooledConnectionFactoryAdd INSTANCE = new PooledConnectionFactoryAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (AttributeDefinition attribute : PooledConnectionFactoryAttribute.getDefinitions(JMSServices.POOLED_CONNECTION_FACTORY_ATTRS)) {
            String attrName = attribute.getName();
            if (!subModel.has(attrName)) continue;
            operation.get(attrName).set(subModel.get(attrName));
        }
        return operation;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : PooledConnectionFactoryAttribute.getDefinitions(JMSServices.POOLED_CONNECTION_FACTORY_ATTRS)) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String txType;
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        ModelNode resolvedModel = model.clone();
        for (AttributeDefinition attribute : PooledConnectionFactoryAttribute.getDefinitions(JMSServices.POOLED_CONNECTION_FACTORY_ATTRS)) {
            resolvedModel.get(attribute.getName()).set(attribute.resolveModelAttribute(context, resolvedModel));
        }
        String jndiName = ((ModelNode)resolvedModel.get(CommonAttributes.ENTRIES.getName()).asList().get(0)).asString();
        int minPoolSize = resolvedModel.get(CommonAttributes.MIN_POOL_SIZE.getName()).asInt();
        int maxPoolSize = resolvedModel.get(CommonAttributes.MAX_POOL_SIZE.getName()).asInt();
        String txSupport = resolvedModel.hasDefined("transaction") ? ("local".equals(txType = resolvedModel.get("transaction").asString()) ? "LocalTransaction" : ("none".equals(txType) ? "NoTransaction" : "XATransaction")) : "XATransaction";
        ServiceTarget serviceTarget = context.getServiceTarget();
        List<String> connectors = PooledConnectionFactoryAdd.getConnectors(resolvedModel);
        String discoveryGroupName = PooledConnectionFactoryAdd.getDiscoveryGroup(resolvedModel);
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(resolvedModel, context);
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(address);
        ServiceName hornetQResourceAdapterService = JMSServices.getPooledConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name});
        PooledConnectionFactoryService resourceAdapterService = new PooledConnectionFactoryService(name, connectors, discoveryGroupName, adapterParams, jndiName, txSupport, minPoolSize, maxPoolSize);
        ServiceBuilder serviceBuilder = serviceTarget.addService(hornetQResourceAdapterService, (Service)resourceAdapterService).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, resourceAdapterService.getTransactionManager()).addDependency(hqServiceName, HornetQServer.class, resourceAdapterService.getHornetQService()).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName)).addListener((ServiceListener)verificationHandler);
        newControllers.add(serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static List<String> getConnectors(ModelNode model) {
        ArrayList<String> connectorNames = new ArrayList<String>();
        if (model.hasDefined("connector")) {
            for (String connectorName : model.get("connector").keys()) {
                connectorNames.add(connectorName);
            }
        }
        return connectorNames;
    }

    static String getDiscoveryGroup(ModelNode model) {
        if (model.hasDefined(CommonAttributes.DISCOVERY_GROUP_NAME.getName())) {
            return model.get(CommonAttributes.DISCOVERY_GROUP_NAME.getName()).asString();
        }
        return null;
    }

    static List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model, OperationContext context) throws OperationFailedException {
        ArrayList<PooledConnectionFactoryConfigProperties> configs = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (PooledConnectionFactoryAttribute nodeAttribute : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            AttributeDefinition definition;
            ModelNode node;
            if (!nodeAttribute.isResourceAdapterProperty() || !(node = (definition = nodeAttribute.getDefinition()).resolveModelAttribute(context, model)).isDefined()) continue;
            String value = node.asString();
            configs.add(new PooledConnectionFactoryConfigProperties(nodeAttribute.getPropertyName(), value, nodeAttribute.getClassType()));
        }
        return configs;
    }
}

