/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.MessagingMessages;

public class PooledConnectionFactoryAttribute {
    private final AttributeDefinition attributeDefinition;
    private String propertyName;
    private final boolean resourceAdapterProperty;

    public static PooledConnectionFactoryAttribute create(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty) {
        return new PooledConnectionFactoryAttribute(attributeDefinition, propertyName, resourceAdapterProperty);
    }

    public static AttributeDefinition[] getDefinitions(PooledConnectionFactoryAttribute ... attrs) {
        AttributeDefinition[] definitions = new AttributeDefinition[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            PooledConnectionFactoryAttribute attr = attrs[i];
            definitions[i] = attr.getDefinition();
        }
        return definitions;
    }

    private PooledConnectionFactoryAttribute(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty) {
        this.attributeDefinition = attributeDefinition;
        this.propertyName = propertyName;
        this.resourceAdapterProperty = resourceAdapterProperty;
    }

    public String getClassType() {
        switch (this.attributeDefinition.getType()) {
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case BIG_DECIMAL: {
                return Double.class.getName();
            }
            case LONG: {
                return Long.class.getName();
            }
            case INT: {
                return Integer.class.getName();
            }
            case STRING: {
                return String.class.getName();
            }
        }
        throw MessagingMessages.MESSAGES.invalidAttributeType(this.attributeDefinition.getName(), this.attributeDefinition.getType());
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public AttributeDefinition getDefinition() {
        return this.attributeDefinition;
    }

    public boolean isResourceAdapterProperty() {
        return this.resourceAdapterProperty;
    }
}

