/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ModClusterSubsystemDescriptions {
    static final String RESOURCE_NAME = ModClusterSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    ModClusterSubsystemDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("modcluster"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("namespace").set(Namespace.MODCLUSTER.getUriString());
        ModClusterSubsystemDescriptions.getConfigurationCommonDescription(node.get(new String[]{"attributes", "mod-cluster-config"}), bundle);
        return node;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("modcluster.add"));
        return node;
    }

    static ModelNode getListProxiesDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("list-proxies");
        node.get("description").set(bundle.getString("modcluster.list-proxies"));
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    static ModelNode getConfigurationCommonDescription(ModelNode node, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("modcluster.configuration"));
        node.get("required").set(false);
        return node;
    }
}

