/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.InitialContextFactoryBuilder;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.ObjectFactoryBuilder;
import org.jboss.as.naming.util.NameParser;
import org.jboss.as.naming.util.NamingUtils;
import org.jboss.logging.Logger;

public class NamingContext
implements EventContext {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");
    private static NamingStore ACTIVE_NAMING_STORE = new InMemoryNamingStore();
    private static final String PACKAGE_PREFIXES = "org.jboss.as.naming.interfaces";
    private static final NameParser nameParser = new NameParser();
    private final NamingStore namingStore;
    private final Name prefix;
    private final Hashtable<String, Object> environment;

    public static void setActiveNamingStore(NamingStore namingStore) {
        ACTIVE_NAMING_STORE = namingStore;
    }

    public static void initializeNamingManager() {
        System.setProperty("java.naming.factory.url.pkgs", PACKAGE_PREFIXES);
        try {
            if (!NamingManager.hasInitialContextFactoryBuilder()) {
                NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilder());
            }
        }
        catch (NamingException e) {
            log.warn((Object)"Failed to set InitialContextFactoryBuilder", (Throwable)e);
        }
        try {
            NamingManager.setObjectFactoryBuilder(ObjectFactoryBuilder.INSTANCE);
        }
        catch (Throwable t) {
            log.warn((Object)"Failed to set ObjectFactoryBuilder", t);
        }
    }

    public NamingContext(Hashtable<String, Object> environment) throws NamingException {
        this(NamingUtils.emptyName(), ACTIVE_NAMING_STORE, environment);
    }

    public NamingContext(Name prefix, Hashtable<String, Object> environment) throws NamingException {
        this(prefix, ACTIVE_NAMING_STORE, environment);
    }

    public NamingContext(Name prefix, NamingStore namingStore, Hashtable<String, Object> environment) throws NamingException {
        if (prefix == null) {
            throw new IllegalArgumentException("Naming prefix can not be null");
        }
        this.prefix = prefix;
        if (namingStore == null) {
            throw new IllegalArgumentException("NamingStore can not be null");
        }
        this.namingStore = namingStore;
        this.environment = environment != null ? NamingUtils.clone(environment) : new Hashtable();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object result;
        if (NamingUtils.isEmpty(name)) {
            return new NamingContext(this.prefix, this.namingStore, this.environment);
        }
        Name absoluteName = this.getAbsoluteName(name);
        try {
            result = this.namingStore.lookup(absoluteName);
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            result = continuationContext.lookup(cpe.getRemainingName());
        }
        if (result instanceof ResolveResult) {
            ResolveResult resolveResult = (ResolveResult)NamingUtils.cast(result);
            Object resolvedObject = resolveResult.getResolvedObj();
            Object context = resolvedObject instanceof LinkRef ? this.resolveLink(resolvedObject) : this.getObjectInstance(resolvedObject, absoluteName, this.environment);
            if (!(context instanceof Context)) {
                throw NamingUtils.notAContextException(absoluteName.getPrefix(absoluteName.size() - resolveResult.getRemainingName().size()));
            }
            Context namingContext = (Context)NamingUtils.cast(context);
            return namingContext.lookup(resolveResult.getRemainingName());
        }
        if (result instanceof LinkRef) {
            result = this.resolveLink(result);
        } else if (result instanceof Reference && (result = this.getObjectInstance(result, absoluteName, this.environment)) instanceof LinkRef) {
            result = this.resolveLink(result);
        }
        return result;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.parseName(name));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        Name absoluteName = this.getAbsoluteName(name);
        if ((object = NamingManager.getStateToBind(object, absoluteName, this, this.environment)) instanceof Referenceable) {
            object = NamingUtils.asReferenceable(object).getReference();
        }
        String className = object.getClass().getName();
        if (object instanceof Reference) {
            className = NamingUtils.asReference(object).getClassName();
        }
        try {
            this.namingStore.bind(this, absoluteName, object, className);
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            continuationContext.bind(cpe.getRemainingName(), object);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.parseName(name), obj);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        Name absoluteName = this.getAbsoluteName(name);
        if ((object = NamingManager.getStateToBind(object, absoluteName, this, this.environment)) instanceof Referenceable) {
            object = NamingUtils.asReferenceable(object).getReference();
        }
        String className = object.getClass().getName();
        if (object instanceof Reference) {
            className = NamingUtils.asReference(object).getClassName();
        }
        try {
            this.namingStore.rebind(this, absoluteName, object, className);
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            continuationContext.rebind(cpe.getRemainingName(), object);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.parseName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            this.namingStore.unbind(this, this.getAbsoluteName(name));
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            continuationContext.unbind(cpe.getRemainingName());
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.parseName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.parseName(oldName), this.parseName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        try {
            return NamingUtils.namingEnumeration(this.namingStore.list(this.getAbsoluteName(name)));
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            return continuationContext.list(cpe.getRemainingName());
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.parseName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        try {
            return NamingUtils.namingEnumeration(this.namingStore.listBindings(this.getAbsoluteName(name)));
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            return continuationContext.listBindings(cpe.getRemainingName());
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.parseName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Name absoluteName = this.getAbsoluteName(name);
        if (this.list(name).hasMore()) {
            throw new ContextNotEmptyException(absoluteName.toString());
        }
        this.unbind(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.parseName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        try {
            return this.namingStore.createSubcontext(this, this.getAbsoluteName(name));
        }
        catch (CannotProceedException cpe) {
            Context continuationContext = NamingManager.getContinuationContext(cpe);
            return continuationContext.createSubcontext(cpe.getRemainingName());
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.lookup(name);
        }
        try {
            Name absoluteName = this.getAbsoluteName(name);
            Object link = this.namingStore.lookup(absoluteName);
            if (!(link instanceof LinkRef) && link instanceof Reference) {
                link = this.getObjectInstance(link, name, null);
            }
            return link;
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Could not lookup link", e, name);
        }
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(this.parseName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = NamingUtils.clone(prefix);
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this.parseName(name), this.parseName(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object existing = this.environment.get(propName);
        this.environment.put(propName, propVal);
        return existing;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener listener) throws NamingException {
        this.namingStore.addNamingListener(target, scope, listener);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener listener) throws NamingException {
        this.addNamingListener(this.parseName(target), scope, listener);
    }

    @Override
    public void removeNamingListener(NamingListener listener) throws NamingException {
        this.namingStore.removeNamingListener(listener);
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    private Name parseName(String name) throws NamingException {
        return this.getNameParser(name).parse(name);
    }

    private Name getAbsoluteName(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.composeName(name, this.prefix);
        }
        String firstComponent = name.get(0);
        if (firstComponent.startsWith("java:")) {
            String cleaned = firstComponent.substring(5);
            Name suffix = name.getSuffix(1);
            if (cleaned.isEmpty()) {
                return suffix;
            }
            return suffix.add(0, cleaned);
        }
        if (firstComponent.isEmpty()) {
            return name.getSuffix(1);
        }
        return this.composeName(name, this.prefix);
    }

    private Object getObjectInstance(Object object, Name name, Hashtable environment) throws NamingException {
        try {
            ObjectFactoryBuilder factoryBuilder = ObjectFactoryBuilder.INSTANCE;
            ObjectFactory objectFactory = factoryBuilder.createObjectFactory(object, environment);
            return objectFactory.getObjectInstance(object, name, this, environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw NamingUtils.namingException("Could not dereference object", t);
        }
    }

    private Object resolveLink(Object result) throws NamingException {
        Object linkResult;
        try {
            LinkRef linkRef = (LinkRef)NamingUtils.cast(result);
            String referenceName = linkRef.getLinkName();
            linkResult = referenceName.startsWith("./") ? this.lookup(referenceName.substring(2)) : new InitialContext().lookup(referenceName);
        }
        catch (Throwable t) {
            throw NamingUtils.namingException("Could not dereference object", t);
        }
        return linkResult;
    }
}

