/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ContextService
implements Service<Context> {
    private final InjectedValue<Context> parentContextValue = new InjectedValue();
    private final String contextName;
    private Context context;

    public ContextService(String contextName) {
        this.contextName = contextName;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            Context parentContext = this.getParentContext();
            this.context = parentContext.createSubcontext(this.contextName);
        }
        catch (NamingException e) {
            throw new StartException("Failed to create context", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            Context parentContext = this.getParentContext();
            parentContext.unbind(this.contextName);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to unbind context", e);
        }
    }

    private Context getParentContext() throws NamingException {
        Context parentContext = (Context)this.parentContextValue.getOptionalValue();
        if (parentContext == null) {
            parentContext = new InitialContext();
        }
        return parentContext;
    }

    public Context getValue() throws IllegalStateException {
        return this.context;
    }

    public Injector<Context> getParentContextInjector() {
        return this.parentContextValue;
    }
}

