/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.NamingException;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingEventCoordinator;
import org.jboss.as.naming.NamingStore;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NamingService
implements Service<NamingStore> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"naming"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");
    private NamingStore namingStore;
    private final boolean supportEvents;

    public NamingService(boolean supportEvents) {
        this.supportEvents = supportEvents;
    }

    public synchronized void start(StartContext context) throws StartException {
        log.info((Object)"Starting Naming Service ");
        try {
            this.namingStore = this.supportEvents ? new InMemoryNamingStore(new NamingEventCoordinator()) : new InMemoryNamingStore();
            NamingContext.setActiveNamingStore(this.namingStore);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start naming server", t);
        }
    }

    public synchronized void stop(StopContext context) {
        NamingContext.setActiveNamingStore(null);
        try {
            this.namingStore.close();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized NamingStore getValue() throws IllegalStateException {
        return this.namingStore;
    }
}

