/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.ResolveResult;
import org.jboss.as.naming.AtomicMapFieldUpdater;
import org.jboss.as.naming.JndiPermission;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingEventCoordinator;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.util.NamingUtils;

public class InMemoryNamingStore
implements NamingStore {
    private final ContextNode root = new ContextNode(null, null, new CompositeName(), new NamingContext(this, null));
    private final NamingEventCoordinator eventCoordinator;
    private final ReentrantLock writeLock = new ReentrantLock();
    private static final AtomicMapFieldUpdater<ContextNode, String, TreeNode> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ContextNode.class, Map.class, "children"));

    public InMemoryNamingStore() {
        this(null);
    }

    public InMemoryNamingStore(NamingEventCoordinator eventCoordinator) {
        this.eventCoordinator = eventCoordinator;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.bind(name, object, object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Name name, Object object, Class<?> bindType) throws NamingException {
        if (NamingUtils.isLastComponentEmpty(name)) {
            throw NamingUtils.emptyNameException();
        }
        this.checkPermissions(name, JndiPermission.Action.BIND);
        this.writeLock.lock();
        try {
            this.root.accept(new BindVisitor(true, name, object, bindType.getName()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name, object, object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object object, Class<?> bindType) throws NamingException {
        if (NamingUtils.isLastComponentEmpty(name)) {
            throw NamingUtils.emptyNameException();
        }
        this.checkPermissions(name, JndiPermission.Action.REBIND);
        this.writeLock.lock();
        try {
            this.root.accept(new RebindVisitor(name, object, bindType.getName()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Name name) throws NamingException {
        if (NamingUtils.isLastComponentEmpty(name)) {
            throw NamingUtils.emptyNameException();
        }
        this.checkPermissions(name, JndiPermission.Action.UNBIND);
        this.writeLock.lock();
        try {
            this.root.accept(new UnbindVisitor(name));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (NamingUtils.isEmpty(name)) {
            CompositeName emptyName = new CompositeName("");
            this.checkPermissions(emptyName, JndiPermission.Action.LOOKUP);
            return new NamingContext(emptyName, this, new Hashtable<String, Object>());
        }
        this.checkPermissions(name, JndiPermission.Action.LOOKUP);
        return this.root.accept(new LookupVisitor(name));
    }

    @Override
    public List<NameClassPair> list(Name name) throws NamingException {
        Name nodeName = name.isEmpty() ? new CompositeName("") : name;
        this.checkPermissions(nodeName, JndiPermission.Action.LIST);
        return this.root.accept(new ListVisitor(nodeName));
    }

    @Override
    public List<Binding> listBindings(Name name) throws NamingException {
        Name nodeName = name.isEmpty() ? new CompositeName("") : name;
        this.checkPermissions(nodeName, JndiPermission.Action.LIST_BINDINGS);
        return this.root.accept(new ListBindingsVisitor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws NamingException {
        this.writeLock.lock();
        try {
            this.root.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener listener) {
        NamingEventCoordinator coordinator = this.eventCoordinator;
        if (coordinator != null) {
            coordinator.addListener(target.toString(), scope, listener);
        }
    }

    @Override
    public void removeNamingListener(NamingListener listener) {
        NamingEventCoordinator coordinator = this.eventCoordinator;
        if (coordinator != null) {
            coordinator.removeListener(listener);
        }
    }

    private void fireEvent(ContextNode contextNode, Name name, Binding existingBinding, Binding newBinding, int type, String changeInfo) {
        Context context;
        NamingEventCoordinator coordinator = this.eventCoordinator;
        if (this.eventCoordinator != null && (context = (Context)Context.class.cast(contextNode.binding.getObject())) instanceof EventContext) {
            coordinator.fireEvent((EventContext)EventContext.class.cast(context), name, existingBinding, newBinding, type, changeInfo, NamingEventCoordinator.DEFAULT_SCOPES);
        }
    }

    private void checkReferenceForContinuation(Name name, Object object) throws CannotProceedException {
        if (object instanceof Reference && ((Reference)object).get("nns") != null) {
            throw NamingUtils.cannotProceedException(object, name);
        }
    }

    private void checkPermissions(Name name, JndiPermission.Action permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JndiPermission(name, permission));
        }
    }

    private final class ListBindingsVisitor
    extends NodeTraversingVisitor<List<Binding>> {
        private ListBindingsVisitor(Name targetName) {
            super(targetName);
        }

        @Override
        protected List<Binding> found(ContextNode contextNode) throws NamingException {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            for (TreeNode childNode : contextNode.children.values()) {
                bindings.add(childNode.binding);
            }
            return bindings;
        }

        @Override
        protected List<Binding> found(BindingNode bindingNode) throws NamingException {
            InMemoryNamingStore.this.checkReferenceForContinuation(new CompositeName(), bindingNode.binding.getObject());
            throw NamingUtils.notAContextException(this.targetName);
        }
    }

    private final class ListVisitor
    extends NodeTraversingVisitor<List<NameClassPair>> {
        private ListVisitor(Name targetName) {
            super(targetName);
        }

        @Override
        protected List<NameClassPair> found(ContextNode contextNode) throws NamingException {
            ArrayList<NameClassPair> nameClassPairs = new ArrayList<NameClassPair>();
            for (TreeNode childNode : contextNode.children.values()) {
                Binding binding = childNode.binding;
                nameClassPairs.add(new NameClassPair(binding.getName(), binding.getClassName(), true));
            }
            return nameClassPairs;
        }

        @Override
        protected List<NameClassPair> found(BindingNode bindingNode) throws NamingException {
            InMemoryNamingStore.this.checkReferenceForContinuation(new CompositeName(), bindingNode.binding.getObject());
            throw NamingUtils.notAContextException(this.targetName);
        }
    }

    private final class LookupVisitor
    extends NodeTraversingVisitor<Object> {
        private LookupVisitor(Name targetName) {
            super(targetName);
        }

        @Override
        protected Object found(ContextNode contextNode) throws NamingException {
            return contextNode.binding.getObject();
        }

        @Override
        protected Object found(BindingNode bindingNode) throws NamingException {
            return bindingNode.binding.getObject();
        }

        @Override
        protected Object foundReferenceInsteadOfContext(BindingNode bindingNode) throws NamingException {
            Name remainingName = this.targetName.getSuffix(bindingNode.fullName.size());
            Object boundObject = bindingNode.binding.getObject();
            InMemoryNamingStore.this.checkReferenceForContinuation(remainingName, boundObject);
            return new ResolveResult(boundObject, remainingName);
        }
    }

    private final class UnbindVisitor
    extends BindingContextVisitor<Void> {
        private UnbindVisitor(Name targetName) throws NamingException {
            super(targetName);
        }

        @Override
        protected Void foundBindContext(ContextNode contextNode) throws NamingException {
            TreeNode previous = contextNode.removeChild(NamingUtils.getLastComponent(this.targetName));
            InMemoryNamingStore.this.fireEvent(contextNode, this.targetName, previous.binding, null, 1, "unbind");
            return null;
        }
    }

    private final class RebindVisitor
    extends BindingContextVisitor<Void> {
        private final Object object;
        private final String className;

        private RebindVisitor(Name name, Object object, String className) {
            super(name);
            this.object = object;
            this.className = className;
        }

        @Override
        protected Void foundBindContext(ContextNode contextNode) throws NamingException {
            Binding binding;
            BindingNode bindingNode;
            String childName = NamingUtils.getLastComponent(this.targetName);
            TreeNode previous = contextNode.replaceChild(childName, bindingNode = new BindingNode(this.targetName, binding = new Binding(childName, this.className, this.object, true)));
            Binding previousBinding = previous != null ? previous.binding : null;
            InMemoryNamingStore.this.fireEvent(contextNode, this.targetName, previousBinding, binding, previousBinding != null ? 3 : 0, "rebind");
            return null;
        }
    }

    private final class BindVisitor
    extends BindingContextVisitor<Void> {
        private final Object object;
        private final String className;

        private BindVisitor(boolean createIfMissing, Name name, Object object, String className) {
            super(createIfMissing, name);
            this.object = object;
            this.className = className;
        }

        @Override
        protected Void foundBindContext(ContextNode contextNode) throws NamingException {
            String childName = NamingUtils.getLastComponent(this.targetName);
            Binding binding = new Binding(childName, this.className, this.object, true);
            BindingNode bindingNode = new BindingNode(this.targetName, binding);
            contextNode.addChild(childName, bindingNode);
            InMemoryNamingStore.this.fireEvent(contextNode, this.targetName, null, binding, 0, "bind");
            return null;
        }
    }

    private abstract class BindingContextVisitor<T>
    extends NodeTraversingVisitor<T> {
        protected final Name targetName;

        protected BindingContextVisitor(boolean createIfMissing, Name targetName) {
            super(createIfMissing, targetName.getPrefix(targetName.size() - 1));
            this.targetName = targetName;
        }

        protected BindingContextVisitor(Name targetName) {
            this(false, targetName);
        }

        @Override
        protected final T found(ContextNode contextNode) throws NamingException {
            return this.foundBindContext(contextNode);
        }

        @Override
        protected final T found(BindingNode bindingNode) throws NamingException {
            InMemoryNamingStore.this.checkReferenceForContinuation(this.targetName.getSuffix(bindingNode.fullName.size()), bindingNode.binding.getObject());
            throw NamingUtils.notAContextException(this.targetName);
        }

        protected abstract T foundBindContext(ContextNode var1) throws NamingException;
    }

    private abstract class NodeTraversingVisitor<T>
    implements NodeVisitor<T> {
        private final boolean createIfMissing;
        private Name currentName;
        protected final Name targetName;

        protected NodeTraversingVisitor(boolean createIfMissing, Name targetName) {
            this.createIfMissing = createIfMissing;
            this.targetName = this.currentName = targetName;
        }

        protected NodeTraversingVisitor(Name targetName) {
            this(false, targetName);
        }

        @Override
        public final T visit(BindingNode bindingNode) throws NamingException {
            if (NamingUtils.isEmpty(this.currentName)) {
                return this.found(bindingNode);
            }
            return this.foundReferenceInsteadOfContext(bindingNode);
        }

        @Override
        public final T visit(ContextNode contextNode) throws NamingException {
            if (NamingUtils.isEmpty(this.currentName)) {
                return this.found(contextNode);
            }
            String childName = this.currentName.get(0);
            this.currentName = this.currentName.getSuffix(1);
            TreeNode node = contextNode.children.get(childName);
            if (node == null) {
                if (this.createIfMissing) {
                    NamingContext subContext = new NamingContext(this.targetName, InMemoryNamingStore.this, new Hashtable<String, Object>());
                    return contextNode.addOrGetChild(childName, new ContextNode(contextNode, childName, this.targetName, subContext)).accept(this);
                }
                throw NamingUtils.nameNotFoundException(childName, contextNode.fullName);
            }
            return node.accept(this);
        }

        protected abstract T found(ContextNode var1) throws NamingException;

        protected abstract T found(BindingNode var1) throws NamingException;

        protected T foundReferenceInsteadOfContext(BindingNode bindingNode) throws NamingException {
            Object object = bindingNode.binding.getObject();
            InMemoryNamingStore.this.checkReferenceForContinuation(this.currentName, object);
            throw NamingUtils.notAContextException(bindingNode.fullName);
        }
    }

    private static interface NodeVisitor<T> {
        public T visit(BindingNode var1) throws NamingException;

        public T visit(ContextNode var1) throws NamingException;
    }

    private class BindingNode
    extends TreeNode {
        private BindingNode(Name fullName, Binding binding) {
            super(fullName, binding);
        }

        @Override
        protected final <T> T accept(NodeVisitor<T> visitor) throws NamingException {
            return visitor.visit(this);
        }
    }

    private class ContextNode
    extends TreeNode {
        volatile Map<String, TreeNode> children;
        protected final String name;
        protected final ContextNode parentNode;

        private ContextNode(ContextNode parentNode, String name, Name fullName, NamingContext context) {
            super(fullName, new Binding(NamingUtils.getLastComponent(fullName), Context.class.getName(), context));
            this.children = Collections.emptyMap();
            this.name = name;
            this.parentNode = parentNode;
        }

        private void addChild(String childName, TreeNode childNode) throws NamingException {
            if (childrenUpdater.putIfAbsent(this, childName, childNode) != null) {
                throw NamingUtils.nameAlreadyBoundException(this.fullName.add(childName));
            }
        }

        private TreeNode replaceChild(String childName, TreeNode childNode) throws NamingException {
            return childrenUpdater.put(this, childName, childNode);
        }

        private TreeNode removeChild(String childName) throws NameNotFoundException {
            TreeNode old = (TreeNode)childrenUpdater.remove(this, childName);
            if (old == null) {
                throw NamingUtils.nameNotFoundException(childName, this.fullName);
            }
            if (this.parentNode != null && this.children.isEmpty()) {
                childrenUpdater.remove(this.parentNode, this.name);
            }
            return old;
        }

        private void clear() {
            childrenUpdater.clear(this);
        }

        @Override
        protected final <T> T accept(NodeVisitor<T> visitor) throws NamingException {
            return visitor.visit(this);
        }

        public TreeNode addOrGetChild(String childName, TreeNode childNode) {
            TreeNode appearing = childrenUpdater.putIfAbsent(this, childName, childNode);
            return appearing == null ? childNode : appearing;
        }
    }

    private abstract class TreeNode {
        protected final Name fullName;
        protected final Binding binding;

        private TreeNode(Name fullName, Binding binding) {
            this.fullName = fullName;
            this.binding = binding;
        }

        protected abstract <T> T accept(NodeVisitor<T> var1) throws NamingException;
    }
}

