/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.context.NamespaceContextSelector;

public class InitialContext
extends NamingContext {
    private static volatile Map<String, ObjectFactory> urlContextFactories = Collections.emptyMap();

    public static synchronized void addUrlContextFactory(String scheme, ObjectFactory factory) {
        HashMap<String, ObjectFactory> factories = new HashMap<String, ObjectFactory>(urlContextFactories);
        factories.put(scheme, factory);
        urlContextFactories = Collections.unmodifiableMap(factories);
    }

    public InitialContext(Hashtable<String, Object> environment) {
        super(environment);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        String scheme;
        ObjectFactory factory;
        String firstPart;
        int index;
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null && !parsedName.remaining().isEmpty() && (index = (firstPart = parsedName.remaining().get(0)).indexOf(58)) != -1 && (factory = urlContextFactories.get(scheme = firstPart.substring(0, index))) != null) {
            try {
                return ((Context)factory.getObjectInstance(null, name, this, this.getEnvironment())).lookup(name);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException n = new NamingException(e.getMessage());
                n.initCause(e);
                throw n;
            }
        }
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.lookup(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.lookup(parsedName.remaining());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.listBindings(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.listBindings(parsedName.remaining());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.list(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.list(parsedName.remaining());
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            super.bind(parsedName.remaining(), object);
            return;
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        namespaceContext.bind(parsedName.remaining(), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            super.rebind(parsedName.remaining(), object);
            return;
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        namespaceContext.rebind(parsedName.remaining(), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            super.unbind(parsedName.remaining());
            return;
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        namespaceContext.unbind(parsedName.remaining());
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            super.destroySubcontext(parsedName.remaining());
            return;
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        namespaceContext.destroySubcontext(parsedName.remaining());
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.createSubcontext(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.createSubcontext(parsedName.remaining());
    }

    private ParsedName parse(Name name) throws NamingException {
        Name remaining;
        String namespace;
        if (name.isEmpty()) {
            namespace = null;
            remaining = name;
        } else {
            String first = name.get(0);
            if (first.startsWith("java:")) {
                String theRest = first.substring(5);
                if (theRest.startsWith("/")) {
                    namespace = null;
                    remaining = this.getNameParser(theRest).parse(theRest);
                } else {
                    namespace = theRest;
                    remaining = name.getSuffix(1);
                }
            } else {
                namespace = null;
                remaining = name;
            }
        }
        return new ParsedName(){

            @Override
            public String namespace() {
                return namespace;
            }

            @Override
            public Name remaining() {
                return remaining;
            }
        };
    }

    private static interface ParsedName {
        public String namespace();

        public Name remaining();
    }
}

