/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.launcher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.embedded.EmbeddedServerFactory;
import org.jboss.as.osgi.launcher.FrameworkProxy;
import org.jboss.as.osgi.launcher.SecurityActions;
import org.jboss.logging.Logger;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public final class EmbeddedFrameworkFactory
implements FrameworkFactory {
    private static Logger log = Logger.getLogger(EmbeddedFrameworkFactory.class);
    private static final String SYSPROP_KEY_JBOSS_HOME = "jboss.home";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_BUNDLE_PATH = "bundle.path";
    private static final String SYSPROP_KEY_JBOSS_SERVER_CONFIG = "jboss.server.config.file.name";

    public Framework newFramework(Map configuration) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (configuration != null) {
            props.putAll(configuration);
        }
        for (Map.Entry entry : props.entrySet()) {
            SecurityActions.setSystemProperty((String)entry.getKey(), (String)entry.getValue());
        }
        log.debugf("Config: " + props, new Object[0]);
        HashSet<String> syspackages = new HashSet<String>();
        syspackages.add("org.osgi.framework");
        syspackages.add("org.osgi.resource");
        syspackages.add("org.osgi.util.tracker");
        this.addConfiguredPackages(syspackages, props, "org.osgi.framework.system.packages");
        this.addConfiguredPackages(syspackages, props, "org.osgi.framework.system.packages.extra");
        this.addConfiguredPackages(syspackages, props, "org.osgi.framework.bootdelegation");
        String jbossHome = this.getProperty(props, SYSPROP_KEY_JBOSS_HOME, null);
        String modulePath = this.getProperty(props, SYSPROP_KEY_MODULE_PATH, null);
        String bundlePath = this.getProperty(props, SYSPROP_KEY_BUNDLE_PATH, null);
        String serverConfig = this.getProperty(props, SYSPROP_KEY_JBOSS_SERVER_CONFIG, "standalone-osgi.xml");
        String[] sysarray = syspackages.toArray(new String[syspackages.size()]);
        String[] cmdargs = new String[]{"--server-config", serverConfig};
        return new FrameworkProxy(EmbeddedServerFactory.create((String)jbossHome, (String)modulePath, (String)bundlePath, (String[])sysarray, (String[])cmdargs));
    }

    private void addConfiguredPackages(Set<String> syspackages, Map<String, String> props, String key) {
        String value = props.get(key);
        if (value != null) {
            for (String token : value.split(",\\s")) {
                int index = token.indexOf(59);
                if (index > 0) {
                    token = token.substring(0, index);
                }
                syspackages.add(token);
            }
        }
    }

    private String getProperty(Map<String, String> props, String key, String defaultValue) {
        String value = props.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

