/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.osgi.deployment.DeployerServicePluginIntegration;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.SecurityActions;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.OSGiModuleLoader;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.DeployerServicePlugin;
import org.jboss.osgi.framework.plugin.ModuleLoaderPlugin;
import org.jboss.osgi.framework.plugin.Plugin;
import org.jboss.osgi.framework.plugin.SystemModuleProviderPlugin;
import org.jboss.osgi.framework.plugin.internal.AbstractSystemModuleProviderPlugin;

public class BundleManagerService
implements Service<BundleManager> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "bundlemanager"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<ServerController> injectedServerController = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedServiceModuleLoader = new InjectedValue();
    private final InjectedValue<SocketBinding> osgiHttpServerPortBinding = new InjectedValue();
    private final SubsystemState subsystemState;
    private BundleManager bundleManager;

    private BundleManagerService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public static void addService(ServiceTarget target, SubsystemState subsystemState) {
        BundleManagerService service = new BundleManagerService(subsystemState);
        ServiceBuilder serviceBuilder = target.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        serviceBuilder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ServerController.class, service.injectedServerController);
        serviceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedServiceModuleLoader);
        serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"osgi-http"}), SocketBinding.class, service.osgiHttpServerPortBinding);
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        serviceBuilder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debugf("Starting OSGi BundleManager", new Object[0]);
        try {
            String handlerModules = SecurityActions.getSystemProperty("jboss.protocol.handler.modules");
            if (handlerModules == null) {
                SecurityActions.setSystemProperty("jboss.protocol.handler.modules", "org.jboss.osgi.framework");
            }
            HashMap<String, Object> props = new HashMap<String, Object>(this.subsystemState.getProperties());
            this.setupIntegrationProperties(context, props);
            this.bundleManager = new BundleManager(props);
            this.bundleManager.addPlugin(SystemModuleProviderPlugin.class, (Plugin)new FrameworkModuleProvider(this.bundleManager));
            ServiceContainer serviceContainer = context.getController().getServiceContainer();
            ModelControllerServerDeploymentManager deploymentManager = new ModelControllerServerDeploymentManager((ModelController)this.injectedServerController.getValue());
            DeployerServicePluginIntegration plugin = new DeployerServicePluginIntegration(this.bundleManager, serviceContainer, (ServerDeploymentManager)deploymentManager);
            this.bundleManager.addPlugin(DeployerServicePlugin.class, (Plugin)plugin);
            ServiceModuleLoader moduleLoader = (ServiceModuleLoader)this.injectedServiceModuleLoader.getValue();
            this.bundleManager.addPlugin(ModuleLoaderPlugin.class, (Plugin)new ModuleLoaderPluginImpl(this.bundleManager, moduleLoader));
        }
        catch (Throwable t) {
            throw new StartException("Failed to create BundleManager", t);
        }
    }

    private void setupIntegrationProperties(StartContext context, Map<String, Object> props) {
        props.put(BundleManager.IntegrationMode.class.getName(), BundleManager.IntegrationMode.CONTAINER);
        ServiceContainer container = context.getController().getServiceContainer();
        props.put(ServiceContainer.class.getName(), container);
        props.put("org.osgi.service.http.port", "" + ((SocketBinding)this.osgiHttpServerPortBinding.getValue()).getSocketAddress().getPort());
        props.put("org.osgi.framework.storage.clean", "onFirstInit");
        String storage = (String)props.get("org.osgi.framework.storage");
        if (storage == null) {
            ServerEnvironment environment = (ServerEnvironment)this.injectedEnvironment.getValue();
            File dataDir = environment.getServerDataDir();
            storage = dataDir.getAbsolutePath() + File.separator + "osgi-store";
            props.put("org.osgi.framework.storage", storage);
        }
    }

    public synchronized void stop(StopContext context) {
        log.debugf("Stopping OSGi BundleManager", new Object[0]);
        try {
            this.bundleManager = null;
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot stop OSGi BundleManager", new Object[0]);
        }
    }

    public BundleManager getValue() throws IllegalStateException {
        return this.bundleManager;
    }

    private static class ModuleLoaderPluginImpl
    extends AbstractPlugin
    implements ModuleLoaderPlugin {
        private ServiceModuleLoader moduleLoader;

        ModuleLoaderPluginImpl(BundleManager bundleManager, ServiceModuleLoader moduleLoader) {
            super(bundleManager);
            this.moduleLoader = moduleLoader;
        }

        public Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
            if (identifier.getName().startsWith("deployment.")) {
                return this.moduleLoader.loadModule(identifier);
            }
            return Module.getBootModuleLoader().loadModule(identifier);
        }
    }

    private static class FrameworkModuleProvider
    extends AbstractSystemModuleProviderPlugin {
        private Module frameworkModule;

        FrameworkModuleProvider(BundleManager bundleManager) {
            super(bundleManager);
        }

        public void destroyPlugin() {
            super.destroyPlugin();
            this.frameworkModule = null;
        }

        public Module getFrameworkModule() {
            return this.frameworkModule;
        }

        public Module createFrameworkModule(OSGiModuleLoader osgiLoader, SystemBundle systemBundle) throws ModuleLoadException {
            ModuleLoader systemLoader = Module.getBootModuleLoader();
            ModuleIdentifier systemIdentifier = this.getSystemModule().getIdentifier();
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.framework"));
            specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ModuleLoader)osgiLoader, (ModuleIdentifier)systemIdentifier, (boolean)false));
            ModuleIdentifier frameworkIdentifier = ModuleIdentifier.create((String)"org.jboss.osgi.framework");
            DependencySpec moduleDep = DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ModuleLoader)systemLoader, (ModuleIdentifier)frameworkIdentifier, (boolean)false);
            specBuilder.addDependency(moduleDep);
            String modulesProps = (String)this.getBundleManager().getProperty("org.jboss.osgi.system.modules");
            if (modulesProps != null) {
                for (String moduleProp : modulesProps.split(",")) {
                    ModuleIdentifier moduleId = ModuleIdentifier.create((String)moduleProp.trim());
                    moduleDep = DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ModuleLoader)systemLoader, (ModuleIdentifier)moduleId, (boolean)false);
                    specBuilder.addDependency(moduleDep);
                }
            }
            ModuleSpec moduleSpec = specBuilder.create();
            osgiLoader.addModule((AbstractRevision)systemBundle.getCurrentRevision(), moduleSpec);
            try {
                this.frameworkModule = osgiLoader.loadModule(specBuilder.getIdentifier());
                return this.frameworkModule;
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

