/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.as.osgi.service.PackageAdminService;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.BundleManager;

public class ModuleRegistrationService
extends AbstractService<Deployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"osgi", "module", "registration"});
    private final Deployment deployment;
    private InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();

    private ModuleRegistrationService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static void addService(ServiceTarget serviceTarget, Deployment deployment, String contextName) {
        ModuleRegistrationService service = new ModuleRegistrationService(deployment);
        ServiceBuilder serviceBuilder = serviceTarget.addService(ModuleRegistrationService.getServiceName(contextName), (Service)service);
        serviceBuilder.addDependency(BundleManagerService.SERVICE_NAME, BundleManager.class, service.injectedBundleManager);
        serviceBuilder.addDependency(PackageAdminService.SERVICE_NAME);
        serviceBuilder.addDependency(Services.deploymentUnitName((String)contextName));
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.install();
    }

    public static ServiceName getServiceName(String contextName) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)contextName);
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public synchronized void stop(StopContext context) {
        log.tracef("Uninstalling deployment: %s", (Object)this.deployment);
        try {
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleManager.uninstallBundle(this.deployment);
            ServiceController controller = context.getController();
            ServiceContainer serviceContainer = controller.getServiceContainer();
            controller.setMode(ServiceController.Mode.REMOVE);
            ServiceName serviceName = Services.deploymentUnitName((String)controller.getName().getSimpleName());
            ServiceController deploymentController = serviceContainer.getService(serviceName);
            if (deploymentController != null) {
                deploymentController.setMode(ServiceController.Mode.REMOVE);
            }
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to uninstall deployment: %s", (Object)this.deployment);
        }
    }

    public Deployment getValue() throws IllegalStateException {
        return this.deployment;
    }
}

